/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.identitystore.model.Address;

@SdkInternalApi
public class AddressMarshaller {
    private static final MarshallingInfo<String> STREETADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreetAddress").build();
    private static final MarshallingInfo<String> LOCALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locality").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<String> FORMATTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Formatted").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Boolean> PRIMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Primary").build();
    private static final AddressMarshaller instance = new AddressMarshaller();

    public static AddressMarshaller getInstance() {
        return instance;
    }

    public void marshall(Address address, ProtocolMarshaller protocolMarshaller) {
        if (address == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)address.getStreetAddress(), STREETADDRESS_BINDING);
            protocolMarshaller.marshall((Object)address.getLocality(), LOCALITY_BINDING);
            protocolMarshaller.marshall((Object)address.getRegion(), REGION_BINDING);
            protocolMarshaller.marshall((Object)address.getPostalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)address.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)address.getFormatted(), FORMATTED_BINDING);
            protocolMarshaller.marshall((Object)address.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)address.getPrimary(), PRIMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

