/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iamrolesanywhere;

import javax.annotation.Generated;

import com.amazonaws.services.iamrolesanywhere.model.*;

/**
 * Abstract implementation of {@code AWSIAMRolesAnywhereAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIAMRolesAnywhereAsync extends AbstractAWSIAMRolesAnywhere implements AWSIAMRolesAnywhereAsync {

    protected AbstractAWSIAMRolesAnywhereAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request) {

        return createProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProfileRequest, CreateProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTrustAnchorResult> createTrustAnchorAsync(CreateTrustAnchorRequest request) {

        return createTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTrustAnchorResult> createTrustAnchorAsync(CreateTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTrustAnchorRequest, CreateTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCrlResult> deleteCrlAsync(DeleteCrlRequest request) {

        return deleteCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCrlResult> deleteCrlAsync(DeleteCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCrlRequest, DeleteCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request) {

        return deleteProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProfileRequest, DeleteProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTrustAnchorResult> deleteTrustAnchorAsync(DeleteTrustAnchorRequest request) {

        return deleteTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTrustAnchorResult> deleteTrustAnchorAsync(DeleteTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTrustAnchorRequest, DeleteTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisableCrlResult> disableCrlAsync(DisableCrlRequest request) {

        return disableCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisableCrlResult> disableCrlAsync(DisableCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<DisableCrlRequest, DisableCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisableProfileResult> disableProfileAsync(DisableProfileRequest request) {

        return disableProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisableProfileResult> disableProfileAsync(DisableProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DisableProfileRequest, DisableProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisableTrustAnchorResult> disableTrustAnchorAsync(DisableTrustAnchorRequest request) {

        return disableTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisableTrustAnchorResult> disableTrustAnchorAsync(DisableTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<DisableTrustAnchorRequest, DisableTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<EnableCrlResult> enableCrlAsync(EnableCrlRequest request) {

        return enableCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<EnableCrlResult> enableCrlAsync(EnableCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<EnableCrlRequest, EnableCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<EnableProfileResult> enableProfileAsync(EnableProfileRequest request) {

        return enableProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<EnableProfileResult> enableProfileAsync(EnableProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<EnableProfileRequest, EnableProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<EnableTrustAnchorResult> enableTrustAnchorAsync(EnableTrustAnchorRequest request) {

        return enableTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<EnableTrustAnchorResult> enableTrustAnchorAsync(EnableTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<EnableTrustAnchorRequest, EnableTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCrlResult> getCrlAsync(GetCrlRequest request) {

        return getCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCrlResult> getCrlAsync(GetCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCrlRequest, GetCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetProfileResult> getProfileAsync(GetProfileRequest request) {

        return getProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetProfileResult> getProfileAsync(GetProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetProfileRequest, GetProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSubjectResult> getSubjectAsync(GetSubjectRequest request) {

        return getSubjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSubjectResult> getSubjectAsync(GetSubjectRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSubjectRequest, GetSubjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTrustAnchorResult> getTrustAnchorAsync(GetTrustAnchorRequest request) {

        return getTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTrustAnchorResult> getTrustAnchorAsync(GetTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTrustAnchorRequest, GetTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ImportCrlResult> importCrlAsync(ImportCrlRequest request) {

        return importCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ImportCrlResult> importCrlAsync(ImportCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<ImportCrlRequest, ImportCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCrlsResult> listCrlsAsync(ListCrlsRequest request) {

        return listCrlsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCrlsResult> listCrlsAsync(ListCrlsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCrlsRequest, ListCrlsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request) {

        return listProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProfilesRequest, ListProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSubjectsResult> listSubjectsAsync(ListSubjectsRequest request) {

        return listSubjectsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSubjectsResult> listSubjectsAsync(ListSubjectsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSubjectsRequest, ListSubjectsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrustAnchorsResult> listTrustAnchorsAsync(ListTrustAnchorsRequest request) {

        return listTrustAnchorsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrustAnchorsResult> listTrustAnchorsAsync(ListTrustAnchorsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrustAnchorsRequest, ListTrustAnchorsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutNotificationSettingsResult> putNotificationSettingsAsync(PutNotificationSettingsRequest request) {

        return putNotificationSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutNotificationSettingsResult> putNotificationSettingsAsync(PutNotificationSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<PutNotificationSettingsRequest, PutNotificationSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ResetNotificationSettingsResult> resetNotificationSettingsAsync(ResetNotificationSettingsRequest request) {

        return resetNotificationSettingsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ResetNotificationSettingsResult> resetNotificationSettingsAsync(ResetNotificationSettingsRequest request,
            com.amazonaws.handlers.AsyncHandler<ResetNotificationSettingsRequest, ResetNotificationSettingsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCrlResult> updateCrlAsync(UpdateCrlRequest request) {

        return updateCrlAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCrlResult> updateCrlAsync(UpdateCrlRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCrlRequest, UpdateCrlResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request) {

        return updateProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProfileRequest, UpdateProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTrustAnchorResult> updateTrustAnchorAsync(UpdateTrustAnchorRequest request) {

        return updateTrustAnchorAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTrustAnchorResult> updateTrustAnchorAsync(UpdateTrustAnchorRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTrustAnchorRequest, UpdateTrustAnchorResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
