/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.identitymanagement.model.CreateOpenIDConnectProviderRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateOpenIDConnectProviderRequestMarshaller
implements Marshaller<Request<CreateOpenIDConnectProviderRequest>, CreateOpenIDConnectProviderRequest> {
    public Request<CreateOpenIDConnectProviderRequest> marshall(CreateOpenIDConnectProviderRequest createOpenIDConnectProviderRequest) {
        if (createOpenIDConnectProviderRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createOpenIDConnectProviderRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        if (createOpenIDConnectProviderRequest.getUrl() != null) {
            request.addParameter("Url", StringUtils.fromString((String)createOpenIDConnectProviderRequest.getUrl()));
        }
        List<String> clientIDListList = createOpenIDConnectProviderRequest.getClientIDList();
        int clientIDListListIndex = 1;
        for (String clientIDListListValue : clientIDListList) {
            if (clientIDListListValue != null) {
                request.addParameter("ClientIDList.member." + clientIDListListIndex, StringUtils.fromString((String)clientIDListListValue));
            }
            ++clientIDListListIndex;
        }
        List<String> thumbprintListList = createOpenIDConnectProviderRequest.getThumbprintList();
        int thumbprintListListIndex = 1;
        for (String thumbprintListListValue : thumbprintListList) {
            if (thumbprintListListValue != null) {
                request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringUtils.fromString((String)thumbprintListListValue));
            }
            ++thumbprintListListIndex;
        }
        return request;
    }
}

