/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.identitymanagement.model;

import java.io.Serializable;

/**
 * <p>
 * Contains the response to a successful ListSSHPublicKeys request.
 * </p>
 */
public class ListSSHPublicKeysResult implements Serializable, Cloneable {

    /**
     * A list of SSH public keys.
     */
    private com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata> sSHPublicKeys;

    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request
     * using the <code>Marker</code> request parameter to retrieve more
     * items.
     */
    private Boolean isTruncated;

    /**
     * When <code>IsTruncated</code> is <code>true</code>, this element is
     * present and contains the value to use for the <code>Marker</code>
     * parameter in a subsequent pagination request.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 320<br/>
     * <b>Pattern: </b>[&#92;u0020-&#92;u00FF]+<br/>
     */
    private String marker;

    /**
     * A list of SSH public keys.
     *
     * @return A list of SSH public keys.
     */
    public java.util.List<SSHPublicKeyMetadata> getSSHPublicKeys() {
        if (sSHPublicKeys == null) {
              sSHPublicKeys = new com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata>();
              sSHPublicKeys.setAutoConstruct(true);
        }
        return sSHPublicKeys;
    }
    
    /**
     * A list of SSH public keys.
     *
     * @param sSHPublicKeys A list of SSH public keys.
     */
    public void setSSHPublicKeys(java.util.Collection<SSHPublicKeyMetadata> sSHPublicKeys) {
        if (sSHPublicKeys == null) {
            this.sSHPublicKeys = null;
            return;
        }
        com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata> sSHPublicKeysCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata>(sSHPublicKeys.size());
        sSHPublicKeysCopy.addAll(sSHPublicKeys);
        this.sSHPublicKeys = sSHPublicKeysCopy;
    }
    
    /**
     * A list of SSH public keys.
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setSSHPublicKeys(java.util.Collection)} or {@link
     * #withSSHPublicKeys(java.util.Collection)} if you want to override the
     * existing values.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param sSHPublicKeys A list of SSH public keys.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ListSSHPublicKeysResult withSSHPublicKeys(SSHPublicKeyMetadata... sSHPublicKeys) {
        if (getSSHPublicKeys() == null) setSSHPublicKeys(new java.util.ArrayList<SSHPublicKeyMetadata>(sSHPublicKeys.length));
        for (SSHPublicKeyMetadata value : sSHPublicKeys) {
            getSSHPublicKeys().add(value);
        }
        return this;
    }
    
    /**
     * A list of SSH public keys.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param sSHPublicKeys A list of SSH public keys.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ListSSHPublicKeysResult withSSHPublicKeys(java.util.Collection<SSHPublicKeyMetadata> sSHPublicKeys) {
        if (sSHPublicKeys == null) {
            this.sSHPublicKeys = null;
        } else {
            com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata> sSHPublicKeysCopy = new com.amazonaws.internal.ListWithAutoConstructFlag<SSHPublicKeyMetadata>(sSHPublicKeys.size());
            sSHPublicKeysCopy.addAll(sSHPublicKeys);
            this.sSHPublicKeys = sSHPublicKeysCopy;
        }

        return this;
    }

    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request
     * using the <code>Marker</code> request parameter to retrieve more
     * items.
     *
     * @return A flag that indicates whether there are more items to return. If your
     *         results were truncated, you can make a subsequent pagination request
     *         using the <code>Marker</code> request parameter to retrieve more
     *         items.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }
    
    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request
     * using the <code>Marker</code> request parameter to retrieve more
     * items.
     *
     * @param isTruncated A flag that indicates whether there are more items to return. If your
     *         results were truncated, you can make a subsequent pagination request
     *         using the <code>Marker</code> request parameter to retrieve more
     *         items.
     */
    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }
    
    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request
     * using the <code>Marker</code> request parameter to retrieve more
     * items.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param isTruncated A flag that indicates whether there are more items to return. If your
     *         results were truncated, you can make a subsequent pagination request
     *         using the <code>Marker</code> request parameter to retrieve more
     *         items.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ListSSHPublicKeysResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    /**
     * A flag that indicates whether there are more items to return. If your
     * results were truncated, you can make a subsequent pagination request
     * using the <code>Marker</code> request parameter to retrieve more
     * items.
     *
     * @return A flag that indicates whether there are more items to return. If your
     *         results were truncated, you can make a subsequent pagination request
     *         using the <code>Marker</code> request parameter to retrieve more
     *         items.
     */
    public Boolean getIsTruncated() {
        return isTruncated;
    }

    /**
     * When <code>IsTruncated</code> is <code>true</code>, this element is
     * present and contains the value to use for the <code>Marker</code>
     * parameter in a subsequent pagination request.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 320<br/>
     * <b>Pattern: </b>[&#92;u0020-&#92;u00FF]+<br/>
     *
     * @return When <code>IsTruncated</code> is <code>true</code>, this element is
     *         present and contains the value to use for the <code>Marker</code>
     *         parameter in a subsequent pagination request.
     */
    public String getMarker() {
        return marker;
    }
    
    /**
     * When <code>IsTruncated</code> is <code>true</code>, this element is
     * present and contains the value to use for the <code>Marker</code>
     * parameter in a subsequent pagination request.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 320<br/>
     * <b>Pattern: </b>[&#92;u0020-&#92;u00FF]+<br/>
     *
     * @param marker When <code>IsTruncated</code> is <code>true</code>, this element is
     *         present and contains the value to use for the <code>Marker</code>
     *         parameter in a subsequent pagination request.
     */
    public void setMarker(String marker) {
        this.marker = marker;
    }
    
    /**
     * When <code>IsTruncated</code> is <code>true</code>, this element is
     * present and contains the value to use for the <code>Marker</code>
     * parameter in a subsequent pagination request.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     * <p>
     * <b>Constraints:</b><br/>
     * <b>Length: </b>1 - 320<br/>
     * <b>Pattern: </b>[&#92;u0020-&#92;u00FF]+<br/>
     *
     * @param marker When <code>IsTruncated</code> is <code>true</code>, this element is
     *         present and contains the value to use for the <code>Marker</code>
     *         parameter in a subsequent pagination request.
     *
     * @return A reference to this updated object so that method calls can be chained
     *         together.
     */
    public ListSSHPublicKeysResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSSHPublicKeys() != null) sb.append("SSHPublicKeys: " + getSSHPublicKeys() + ",");
        if (isTruncated() != null) sb.append("IsTruncated: " + isTruncated() + ",");
        if (getMarker() != null) sb.append("Marker: " + getMarker() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getSSHPublicKeys() == null) ? 0 : getSSHPublicKeys().hashCode()); 
        hashCode = prime * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode()); 
        hashCode = prime * hashCode + ((getMarker() == null) ? 0 : getMarker().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof ListSSHPublicKeysResult == false) return false;
        ListSSHPublicKeysResult other = (ListSSHPublicKeysResult)obj;
        
        if (other.getSSHPublicKeys() == null ^ this.getSSHPublicKeys() == null) return false;
        if (other.getSSHPublicKeys() != null && other.getSSHPublicKeys().equals(this.getSSHPublicKeys()) == false) return false; 
        if (other.isTruncated() == null ^ this.isTruncated() == null) return false;
        if (other.isTruncated() != null && other.isTruncated().equals(this.isTruncated()) == false) return false; 
        if (other.getMarker() == null ^ this.getMarker() == null) return false;
        if (other.getMarker() != null && other.getMarker().equals(this.getMarker()) == false) return false; 
        return true;
    }
    
    @Override
    public ListSSHPublicKeysResult clone() {
        try {
            return (ListSSHPublicKeysResult) super.clone();
        
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                    + "even though we're Cloneable!",
                    e);
        }
        
    }

}
    