/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.honeycode.model.transform.CellInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CellInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String fact;
    private List<String> facts;

    public void setFact(String fact) {
        this.fact = fact;
    }

    public String getFact() {
        return this.fact;
    }

    public CellInput withFact(String fact) {
        this.setFact(fact);
        return this;
    }

    public List<String> getFacts() {
        return this.facts;
    }

    public void setFacts(Collection<String> facts) {
        if (facts == null) {
            this.facts = null;
            return;
        }
        this.facts = new ArrayList<String>(facts);
    }

    public CellInput withFacts(String ... facts) {
        if (this.facts == null) {
            this.setFacts(new ArrayList<String>(facts.length));
        }
        for (String ele : facts) {
            this.facts.add(ele);
        }
        return this;
    }

    public CellInput withFacts(Collection<String> facts) {
        this.setFacts(facts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFact() != null) {
            sb.append("Fact: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFacts() != null) {
            sb.append("Facts: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellInput)) {
            return false;
        }
        CellInput other = (CellInput)obj;
        if (other.getFact() == null ^ this.getFact() == null) {
            return false;
        }
        if (other.getFact() != null && !other.getFact().equals(this.getFact())) {
            return false;
        }
        if (other.getFacts() == null ^ this.getFacts() == null) {
            return false;
        }
        return other.getFacts() == null || other.getFacts().equals(this.getFacts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFact() == null ? 0 : this.getFact().hashCode());
        hashCode = 31 * hashCode + (this.getFacts() == null ? 0 : this.getFacts().hashCode());
        return hashCode;
    }

    public CellInput clone() {
        try {
            return (CellInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CellInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

