/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.health.model.DescribeEventAggregatesRequest;
import com.amazonaws.services.health.model.transform.EventFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeEventAggregatesRequestMarshaller
implements Marshaller<Request<DescribeEventAggregatesRequest>, DescribeEventAggregatesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeEventAggregatesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeEventAggregatesRequest> marshall(DescribeEventAggregatesRequest describeEventAggregatesRequest) {
        if (describeEventAggregatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventAggregatesRequest, "AWSHealth");
        request.addHeader("X-Amz-Target", "AWSHealth_20160804.DescribeEventAggregates");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeEventAggregatesRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                EventFilterJsonMarshaller.getInstance().marshall(describeEventAggregatesRequest.getFilter(), jsonGenerator);
            }
            if (describeEventAggregatesRequest.getAggregateField() != null) {
                jsonGenerator.writeFieldName("aggregateField").writeValue(describeEventAggregatesRequest.getAggregateField());
            }
            if (describeEventAggregatesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeEventAggregatesRequest.getMaxResults().intValue());
            }
            if (describeEventAggregatesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeEventAggregatesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

