/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.health.model.AffectedEntity;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class AffectedEntityMarshaller {
    private static final MarshallingInfo<String> ENTITYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityArn").build();
    private static final MarshallingInfo<String> EVENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventArn").build();
    private static final MarshallingInfo<String> ENTITYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entityValue").build();
    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsAccountId").build();
    private static final MarshallingInfo<Date> LASTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final AffectedEntityMarshaller instance = new AffectedEntityMarshaller();

    public static AffectedEntityMarshaller getInstance() {
        return instance;
    }

    public void marshall(AffectedEntity affectedEntity, ProtocolMarshaller protocolMarshaller) {
        if (affectedEntity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)affectedEntity.getEntityArn(), ENTITYARN_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.getEventArn(), EVENTARN_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.getEntityValue(), ENTITYVALUE_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.getAwsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.getLastUpdatedTime(), LASTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)affectedEntity.getStatusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(affectedEntity.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

