/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMalwareProtectionPlans"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListMalwareProtectionPlansResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     */
    private java.util.List<MalwareProtectionPlanSummary> malwareProtectionPlans;
    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     * 
     * @return A list of unique identifiers associated with each Malware Protection plan.
     */

    public java.util.List<MalwareProtectionPlanSummary> getMalwareProtectionPlans() {
        return malwareProtectionPlans;
    }

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlans
     *        A list of unique identifiers associated with each Malware Protection plan.
     */

    public void setMalwareProtectionPlans(java.util.Collection<MalwareProtectionPlanSummary> malwareProtectionPlans) {
        if (malwareProtectionPlans == null) {
            this.malwareProtectionPlans = null;
            return;
        }

        this.malwareProtectionPlans = new java.util.ArrayList<MalwareProtectionPlanSummary>(malwareProtectionPlans);
    }

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalwareProtectionPlans(java.util.Collection)} or
     * {@link #withMalwareProtectionPlans(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param malwareProtectionPlans
     *        A list of unique identifiers associated with each Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMalwareProtectionPlansResult withMalwareProtectionPlans(MalwareProtectionPlanSummary... malwareProtectionPlans) {
        if (this.malwareProtectionPlans == null) {
            setMalwareProtectionPlans(new java.util.ArrayList<MalwareProtectionPlanSummary>(malwareProtectionPlans.length));
        }
        for (MalwareProtectionPlanSummary ele : malwareProtectionPlans) {
            this.malwareProtectionPlans.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of unique identifiers associated with each Malware Protection plan.
     * </p>
     * 
     * @param malwareProtectionPlans
     *        A list of unique identifiers associated with each Malware Protection plan.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMalwareProtectionPlansResult withMalwareProtectionPlans(java.util.Collection<MalwareProtectionPlanSummary> malwareProtectionPlans) {
        setMalwareProtectionPlans(malwareProtectionPlans);
        return this;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.
     * </p>
     * 
     * @param nextToken
     *        You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *        call to the list action. For subsequent calls to the action, fill nextToken in the request with the value
     *        of <code>NextToken</code> from the previous response to continue listing data.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the list action. For subsequent calls to the action, fill nextToken in the request with the value
     *         of <code>NextToken</code> from the previous response to continue listing data.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the list action. For subsequent calls to the action, fill nextToken in the request with the value of
     * <code>NextToken</code> from the previous response to continue listing data.
     * </p>
     * 
     * @param nextToken
     *        You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *        call to the list action. For subsequent calls to the action, fill nextToken in the request with the value
     *        of <code>NextToken</code> from the previous response to continue listing data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListMalwareProtectionPlansResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMalwareProtectionPlans() != null)
            sb.append("MalwareProtectionPlans: ").append(getMalwareProtectionPlans()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListMalwareProtectionPlansResult == false)
            return false;
        ListMalwareProtectionPlansResult other = (ListMalwareProtectionPlansResult) obj;
        if (other.getMalwareProtectionPlans() == null ^ this.getMalwareProtectionPlans() == null)
            return false;
        if (other.getMalwareProtectionPlans() != null && other.getMalwareProtectionPlans().equals(this.getMalwareProtectionPlans()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMalwareProtectionPlans() == null) ? 0 : getMalwareProtectionPlans().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListMalwareProtectionPlansResult clone() {
        try {
            return (ListMalwareProtectionPlansResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
