/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.KubernetesConfiguration;
import com.amazonaws.services.guardduty.model.MalwareProtectionConfiguration;
import com.amazonaws.services.guardduty.model.S3LogsConfiguration;
import com.amazonaws.services.guardduty.model.transform.DataSourceConfigurationsMarshaller;
import java.io.Serializable;

public class DataSourceConfigurations
implements Serializable,
Cloneable,
StructuredPojo {
    private S3LogsConfiguration s3Logs;
    private KubernetesConfiguration kubernetes;
    private MalwareProtectionConfiguration malwareProtection;

    public void setS3Logs(S3LogsConfiguration s3Logs) {
        this.s3Logs = s3Logs;
    }

    public S3LogsConfiguration getS3Logs() {
        return this.s3Logs;
    }

    public DataSourceConfigurations withS3Logs(S3LogsConfiguration s3Logs) {
        this.setS3Logs(s3Logs);
        return this;
    }

    public void setKubernetes(KubernetesConfiguration kubernetes) {
        this.kubernetes = kubernetes;
    }

    public KubernetesConfiguration getKubernetes() {
        return this.kubernetes;
    }

    public DataSourceConfigurations withKubernetes(KubernetesConfiguration kubernetes) {
        this.setKubernetes(kubernetes);
        return this;
    }

    public void setMalwareProtection(MalwareProtectionConfiguration malwareProtection) {
        this.malwareProtection = malwareProtection;
    }

    public MalwareProtectionConfiguration getMalwareProtection() {
        return this.malwareProtection;
    }

    public DataSourceConfigurations withMalwareProtection(MalwareProtectionConfiguration malwareProtection) {
        this.setMalwareProtection(malwareProtection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Logs() != null) {
            sb.append("S3Logs: ").append(this.getS3Logs()).append(",");
        }
        if (this.getKubernetes() != null) {
            sb.append("Kubernetes: ").append(this.getKubernetes()).append(",");
        }
        if (this.getMalwareProtection() != null) {
            sb.append("MalwareProtection: ").append(this.getMalwareProtection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurations)) {
            return false;
        }
        DataSourceConfigurations other = (DataSourceConfigurations)obj;
        if (other.getS3Logs() == null ^ this.getS3Logs() == null) {
            return false;
        }
        if (other.getS3Logs() != null && !other.getS3Logs().equals(this.getS3Logs())) {
            return false;
        }
        if (other.getKubernetes() == null ^ this.getKubernetes() == null) {
            return false;
        }
        if (other.getKubernetes() != null && !other.getKubernetes().equals(this.getKubernetes())) {
            return false;
        }
        if (other.getMalwareProtection() == null ^ this.getMalwareProtection() == null) {
            return false;
        }
        return other.getMalwareProtection() == null || other.getMalwareProtection().equals(this.getMalwareProtection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Logs() == null ? 0 : this.getS3Logs().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetes() == null ? 0 : this.getKubernetes().hashCode());
        hashCode = 31 * hashCode + (this.getMalwareProtection() == null ? 0 : this.getMalwareProtection().hashCode());
        return hashCode;
    }

    public DataSourceConfigurations clone() {
        try {
            return (DataSourceConfigurations)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceConfigurationsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

