/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.Frequency;
import com.amazonaws.services.groundstation.model.Polarization;
import com.amazonaws.services.groundstation.model.transform.UplinkSpectrumConfigMarshaller;
import java.io.Serializable;

public class UplinkSpectrumConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Frequency centerFrequency;
    private String polarization;

    public void setCenterFrequency(Frequency centerFrequency) {
        this.centerFrequency = centerFrequency;
    }

    public Frequency getCenterFrequency() {
        return this.centerFrequency;
    }

    public UplinkSpectrumConfig withCenterFrequency(Frequency centerFrequency) {
        this.setCenterFrequency(centerFrequency);
        return this;
    }

    public void setPolarization(String polarization) {
        this.polarization = polarization;
    }

    public String getPolarization() {
        return this.polarization;
    }

    public UplinkSpectrumConfig withPolarization(String polarization) {
        this.setPolarization(polarization);
        return this;
    }

    public UplinkSpectrumConfig withPolarization(Polarization polarization) {
        this.polarization = polarization.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCenterFrequency() != null) {
            sb.append("CenterFrequency: ").append(this.getCenterFrequency()).append(",");
        }
        if (this.getPolarization() != null) {
            sb.append("Polarization: ").append(this.getPolarization());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkSpectrumConfig)) {
            return false;
        }
        UplinkSpectrumConfig other = (UplinkSpectrumConfig)obj;
        if (other.getCenterFrequency() == null ^ this.getCenterFrequency() == null) {
            return false;
        }
        if (other.getCenterFrequency() != null && !other.getCenterFrequency().equals(this.getCenterFrequency())) {
            return false;
        }
        if (other.getPolarization() == null ^ this.getPolarization() == null) {
            return false;
        }
        return other.getPolarization() == null || other.getPolarization().equals(this.getPolarization());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCenterFrequency() == null ? 0 : this.getCenterFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getPolarization() == null ? 0 : this.getPolarization().hashCode());
        return hashCode;
    }

    public UplinkSpectrumConfig clone() {
        try {
            return (UplinkSpectrumConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UplinkSpectrumConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

