/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.greengrassv2.model.ComponentCandidate;
import com.amazonaws.services.greengrassv2.model.ComponentPlatform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResolveComponentCandidatesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ComponentPlatform platform;
    private List<ComponentCandidate> componentCandidates;

    public void setPlatform(ComponentPlatform platform) {
        this.platform = platform;
    }

    public ComponentPlatform getPlatform() {
        return this.platform;
    }

    public ResolveComponentCandidatesRequest withPlatform(ComponentPlatform platform) {
        this.setPlatform(platform);
        return this;
    }

    public List<ComponentCandidate> getComponentCandidates() {
        return this.componentCandidates;
    }

    public void setComponentCandidates(Collection<ComponentCandidate> componentCandidates) {
        if (componentCandidates == null) {
            this.componentCandidates = null;
            return;
        }
        this.componentCandidates = new ArrayList<ComponentCandidate>(componentCandidates);
    }

    public ResolveComponentCandidatesRequest withComponentCandidates(ComponentCandidate ... componentCandidates) {
        if (this.componentCandidates == null) {
            this.setComponentCandidates(new ArrayList<ComponentCandidate>(componentCandidates.length));
        }
        for (ComponentCandidate ele : componentCandidates) {
            this.componentCandidates.add(ele);
        }
        return this;
    }

    public ResolveComponentCandidatesRequest withComponentCandidates(Collection<ComponentCandidate> componentCandidates) {
        this.setComponentCandidates(componentCandidates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getComponentCandidates() != null) {
            sb.append("ComponentCandidates: ").append(this.getComponentCandidates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveComponentCandidatesRequest)) {
            return false;
        }
        ResolveComponentCandidatesRequest other = (ResolveComponentCandidatesRequest)obj;
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getComponentCandidates() == null ^ this.getComponentCandidates() == null) {
            return false;
        }
        return other.getComponentCandidates() == null || other.getComponentCandidates().equals(this.getComponentCandidates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getComponentCandidates() == null ? 0 : this.getComponentCandidates().hashCode());
        return hashCode;
    }

    public ResolveComponentCandidatesRequest clone() {
        return (ResolveComponentCandidatesRequest)super.clone();
    }
}

