/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrass;

import javax.annotation.Generated;

import com.amazonaws.services.greengrass.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGreengrass}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGreengrass implements AWSGreengrass {

    protected AbstractAWSGreengrass() {
    }

    @Override
    public AssociateRoleToGroupResult associateRoleToGroup(AssociateRoleToGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateServiceRoleToAccountResult associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectorDefinitionResult createConnectorDefinition(CreateConnectorDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectorDefinitionVersionResult createConnectorDefinitionVersion(CreateConnectorDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCoreDefinitionResult createCoreDefinition(CreateCoreDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCoreDefinitionVersionResult createCoreDefinitionVersion(CreateCoreDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceDefinitionResult createDeviceDefinition(CreateDeviceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceDefinitionVersionResult createDeviceDefinitionVersion(CreateDeviceDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFunctionDefinitionResult createFunctionDefinition(CreateFunctionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFunctionDefinitionVersionResult createFunctionDefinitionVersion(CreateFunctionDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupCertificateAuthorityResult createGroupCertificateAuthority(CreateGroupCertificateAuthorityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupVersionResult createGroupVersion(CreateGroupVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLoggerDefinitionResult createLoggerDefinition(CreateLoggerDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLoggerDefinitionVersionResult createLoggerDefinitionVersion(CreateLoggerDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourceDefinitionResult createResourceDefinition(CreateResourceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourceDefinitionVersionResult createResourceDefinitionVersion(CreateResourceDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSoftwareUpdateJobResult createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionDefinitionResult createSubscriptionDefinition(CreateSubscriptionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSubscriptionDefinitionVersionResult createSubscriptionDefinitionVersion(CreateSubscriptionDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectorDefinitionResult deleteConnectorDefinition(DeleteConnectorDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCoreDefinitionResult deleteCoreDefinition(DeleteCoreDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceDefinitionResult deleteDeviceDefinition(DeleteDeviceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFunctionDefinitionResult deleteFunctionDefinition(DeleteFunctionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLoggerDefinitionResult deleteLoggerDefinition(DeleteLoggerDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourceDefinitionResult deleteResourceDefinition(DeleteResourceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSubscriptionDefinitionResult deleteSubscriptionDefinition(DeleteSubscriptionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateRoleFromGroupResult disassociateRoleFromGroup(DisassociateRoleFromGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateServiceRoleFromAccountResult disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssociatedRoleResult getAssociatedRole(GetAssociatedRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBulkDeploymentStatusResult getBulkDeploymentStatus(GetBulkDeploymentStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectivityInfoResult getConnectivityInfo(GetConnectivityInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectorDefinitionResult getConnectorDefinition(GetConnectorDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectorDefinitionVersionResult getConnectorDefinitionVersion(GetConnectorDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreDefinitionResult getCoreDefinition(GetCoreDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreDefinitionVersionResult getCoreDefinitionVersion(GetCoreDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeploymentStatusResult getDeploymentStatus(GetDeploymentStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceDefinitionResult getDeviceDefinition(GetDeviceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeviceDefinitionVersionResult getDeviceDefinitionVersion(GetDeviceDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFunctionDefinitionResult getFunctionDefinition(GetFunctionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFunctionDefinitionVersionResult getFunctionDefinitionVersion(GetFunctionDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupResult getGroup(GetGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupCertificateAuthorityResult getGroupCertificateAuthority(GetGroupCertificateAuthorityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupCertificateConfigurationResult getGroupCertificateConfiguration(GetGroupCertificateConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGroupVersionResult getGroupVersion(GetGroupVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLoggerDefinitionResult getLoggerDefinition(GetLoggerDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLoggerDefinitionVersionResult getLoggerDefinitionVersion(GetLoggerDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceDefinitionResult getResourceDefinition(GetResourceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceDefinitionVersionResult getResourceDefinitionVersion(GetResourceDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServiceRoleForAccountResult getServiceRoleForAccount(GetServiceRoleForAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionDefinitionResult getSubscriptionDefinition(GetSubscriptionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSubscriptionDefinitionVersionResult getSubscriptionDefinitionVersion(GetSubscriptionDefinitionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetThingRuntimeConfigurationResult getThingRuntimeConfiguration(GetThingRuntimeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBulkDeploymentDetailedReportsResult listBulkDeploymentDetailedReports(ListBulkDeploymentDetailedReportsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBulkDeploymentsResult listBulkDeployments(ListBulkDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorDefinitionVersionsResult listConnectorDefinitionVersions(ListConnectorDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorDefinitionsResult listConnectorDefinitions(ListConnectorDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoreDefinitionVersionsResult listCoreDefinitionVersions(ListCoreDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoreDefinitionsResult listCoreDefinitions(ListCoreDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeploymentsResult listDeployments(ListDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceDefinitionVersionsResult listDeviceDefinitionVersions(ListDeviceDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDeviceDefinitionsResult listDeviceDefinitions(ListDeviceDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFunctionDefinitionVersionsResult listFunctionDefinitionVersions(ListFunctionDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFunctionDefinitionsResult listFunctionDefinitions(ListFunctionDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupCertificateAuthoritiesResult listGroupCertificateAuthorities(ListGroupCertificateAuthoritiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupVersionsResult listGroupVersions(ListGroupVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLoggerDefinitionVersionsResult listLoggerDefinitionVersions(ListLoggerDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLoggerDefinitionsResult listLoggerDefinitions(ListLoggerDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceDefinitionVersionsResult listResourceDefinitionVersions(ListResourceDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceDefinitionsResult listResourceDefinitions(ListResourceDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionDefinitionVersionsResult listSubscriptionDefinitionVersions(ListSubscriptionDefinitionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSubscriptionDefinitionsResult listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetDeploymentsResult resetDeployments(ResetDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartBulkDeploymentResult startBulkDeployment(StartBulkDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopBulkDeploymentResult stopBulkDeployment(StopBulkDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectivityInfoResult updateConnectivityInfo(UpdateConnectivityInfoRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectorDefinitionResult updateConnectorDefinition(UpdateConnectorDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCoreDefinitionResult updateCoreDefinition(UpdateCoreDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceDefinitionResult updateDeviceDefinition(UpdateDeviceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFunctionDefinitionResult updateFunctionDefinition(UpdateFunctionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGroupResult updateGroup(UpdateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGroupCertificateConfigurationResult updateGroupCertificateConfiguration(UpdateGroupCertificateConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLoggerDefinitionResult updateLoggerDefinition(UpdateLoggerDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceDefinitionResult updateResourceDefinition(UpdateResourceDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSubscriptionDefinitionResult updateSubscriptionDefinition(UpdateSubscriptionDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateThingRuntimeConfigurationResult updateThingRuntimeConfiguration(UpdateThingRuntimeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
