/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.DataCatalogOutput;
import com.amazonaws.services.gluedatabrew.model.DatabaseOutput;
import com.amazonaws.services.gluedatabrew.model.EncryptionMode;
import com.amazonaws.services.gluedatabrew.model.JobSample;
import com.amazonaws.services.gluedatabrew.model.JobType;
import com.amazonaws.services.gluedatabrew.model.LogSubscription;
import com.amazonaws.services.gluedatabrew.model.Output;
import com.amazonaws.services.gluedatabrew.model.RecipeReference;
import com.amazonaws.services.gluedatabrew.model.transform.JobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Job
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String createdBy;
    private Date createDate;
    private String datasetName;
    private String encryptionKeyArn;
    private String encryptionMode;
    private String name;
    private String type;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private String logSubscription;
    private Integer maxCapacity;
    private Integer maxRetries;
    private List<Output> outputs;
    private List<DataCatalogOutput> dataCatalogOutputs;
    private List<DatabaseOutput> databaseOutputs;
    private String projectName;
    private RecipeReference recipeReference;
    private String resourceArn;
    private String roleArn;
    private Integer timeout;
    private Map<String, String> tags;
    private JobSample jobSample;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Job withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Job withCreatedBy(String createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Job withCreateDate(Date createDate) {
        this.setCreateDate(createDate);
        return this;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public Job withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public void setEncryptionKeyArn(String encryptionKeyArn) {
        this.encryptionKeyArn = encryptionKeyArn;
    }

    public String getEncryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Job withEncryptionKeyArn(String encryptionKeyArn) {
        this.setEncryptionKeyArn(encryptionKeyArn);
        return this;
    }

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }

    public Job withEncryptionMode(String encryptionMode) {
        this.setEncryptionMode(encryptionMode);
        return this;
    }

    public Job withEncryptionMode(EncryptionMode encryptionMode) {
        this.encryptionMode = encryptionMode.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Job withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Job withType(String type) {
        this.setType(type);
        return this;
    }

    public Job withType(JobType type) {
        this.type = type.toString();
        return this;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Job withLastModifiedBy(String lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Job withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setLogSubscription(String logSubscription) {
        this.logSubscription = logSubscription;
    }

    public String getLogSubscription() {
        return this.logSubscription;
    }

    public Job withLogSubscription(String logSubscription) {
        this.setLogSubscription(logSubscription);
        return this;
    }

    public Job withLogSubscription(LogSubscription logSubscription) {
        this.logSubscription = logSubscription.toString();
        return this;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public Job withMaxCapacity(Integer maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Job withMaxRetries(Integer maxRetries) {
        this.setMaxRetries(maxRetries);
        return this;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<Output>(outputs);
    }

    public Job withOutputs(Output ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<Output>(outputs.length));
        }
        for (Output ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public Job withOutputs(Collection<Output> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public List<DataCatalogOutput> getDataCatalogOutputs() {
        return this.dataCatalogOutputs;
    }

    public void setDataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
        if (dataCatalogOutputs == null) {
            this.dataCatalogOutputs = null;
            return;
        }
        this.dataCatalogOutputs = new ArrayList<DataCatalogOutput>(dataCatalogOutputs);
    }

    public Job withDataCatalogOutputs(DataCatalogOutput ... dataCatalogOutputs) {
        if (this.dataCatalogOutputs == null) {
            this.setDataCatalogOutputs(new ArrayList<DataCatalogOutput>(dataCatalogOutputs.length));
        }
        for (DataCatalogOutput ele : dataCatalogOutputs) {
            this.dataCatalogOutputs.add(ele);
        }
        return this;
    }

    public Job withDataCatalogOutputs(Collection<DataCatalogOutput> dataCatalogOutputs) {
        this.setDataCatalogOutputs(dataCatalogOutputs);
        return this;
    }

    public List<DatabaseOutput> getDatabaseOutputs() {
        return this.databaseOutputs;
    }

    public void setDatabaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
        if (databaseOutputs == null) {
            this.databaseOutputs = null;
            return;
        }
        this.databaseOutputs = new ArrayList<DatabaseOutput>(databaseOutputs);
    }

    public Job withDatabaseOutputs(DatabaseOutput ... databaseOutputs) {
        if (this.databaseOutputs == null) {
            this.setDatabaseOutputs(new ArrayList<DatabaseOutput>(databaseOutputs.length));
        }
        for (DatabaseOutput ele : databaseOutputs) {
            this.databaseOutputs.add(ele);
        }
        return this;
    }

    public Job withDatabaseOutputs(Collection<DatabaseOutput> databaseOutputs) {
        this.setDatabaseOutputs(databaseOutputs);
        return this;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Job withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public void setRecipeReference(RecipeReference recipeReference) {
        this.recipeReference = recipeReference;
    }

    public RecipeReference getRecipeReference() {
        return this.recipeReference;
    }

    public Job withRecipeReference(RecipeReference recipeReference) {
        this.setRecipeReference(recipeReference);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Job withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Job withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Job withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Job withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Job addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Job clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setJobSample(JobSample jobSample) {
        this.jobSample = jobSample;
    }

    public JobSample getJobSample() {
        return this.jobSample;
    }

    public Job withJobSample(JobSample jobSample) {
        this.setJobSample(jobSample);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: ").append(this.getCreateDate()).append(",");
        }
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: ").append(this.getDatasetName()).append(",");
        }
        if (this.getEncryptionKeyArn() != null) {
            sb.append("EncryptionKeyArn: ").append(this.getEncryptionKeyArn()).append(",");
        }
        if (this.getEncryptionMode() != null) {
            sb.append("EncryptionMode: ").append(this.getEncryptionMode()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getLogSubscription() != null) {
            sb.append("LogSubscription: ").append(this.getLogSubscription()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getMaxRetries() != null) {
            sb.append("MaxRetries: ").append(this.getMaxRetries()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getDataCatalogOutputs() != null) {
            sb.append("DataCatalogOutputs: ").append(this.getDataCatalogOutputs()).append(",");
        }
        if (this.getDatabaseOutputs() != null) {
            sb.append("DatabaseOutputs: ").append(this.getDatabaseOutputs()).append(",");
        }
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getRecipeReference() != null) {
            sb.append("RecipeReference: ").append(this.getRecipeReference()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getJobSample() != null) {
            sb.append("JobSample: ").append(this.getJobSample());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        if (other.getCreateDate() != null && !other.getCreateDate().equals(this.getCreateDate())) {
            return false;
        }
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getEncryptionKeyArn() == null ^ this.getEncryptionKeyArn() == null) {
            return false;
        }
        if (other.getEncryptionKeyArn() != null && !other.getEncryptionKeyArn().equals(this.getEncryptionKeyArn())) {
            return false;
        }
        if (other.getEncryptionMode() == null ^ this.getEncryptionMode() == null) {
            return false;
        }
        if (other.getEncryptionMode() != null && !other.getEncryptionMode().equals(this.getEncryptionMode())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getLogSubscription() == null ^ this.getLogSubscription() == null) {
            return false;
        }
        if (other.getLogSubscription() != null && !other.getLogSubscription().equals(this.getLogSubscription())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getMaxRetries() == null ^ this.getMaxRetries() == null) {
            return false;
        }
        if (other.getMaxRetries() != null && !other.getMaxRetries().equals(this.getMaxRetries())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getDataCatalogOutputs() == null ^ this.getDataCatalogOutputs() == null) {
            return false;
        }
        if (other.getDataCatalogOutputs() != null && !other.getDataCatalogOutputs().equals(this.getDataCatalogOutputs())) {
            return false;
        }
        if (other.getDatabaseOutputs() == null ^ this.getDatabaseOutputs() == null) {
            return false;
        }
        if (other.getDatabaseOutputs() != null && !other.getDatabaseOutputs().equals(this.getDatabaseOutputs())) {
            return false;
        }
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getRecipeReference() == null ^ this.getRecipeReference() == null) {
            return false;
        }
        if (other.getRecipeReference() != null && !other.getRecipeReference().equals(this.getRecipeReference())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getJobSample() == null ^ this.getJobSample() == null) {
            return false;
        }
        return other.getJobSample() == null || other.getJobSample().equals(this.getJobSample());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKeyArn() == null ? 0 : this.getEncryptionKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionMode() == null ? 0 : this.getEncryptionMode().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getLogSubscription() == null ? 0 : this.getLogSubscription().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRetries() == null ? 0 : this.getMaxRetries().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getDataCatalogOutputs() == null ? 0 : this.getDataCatalogOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseOutputs() == null ? 0 : this.getDatabaseOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getRecipeReference() == null ? 0 : this.getRecipeReference().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getJobSample() == null ? 0 : this.getJobSample().hashCode());
        return hashCode;
    }

    public Job clone() {
        try {
            return (Job)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

