/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gluedatabrew.model.JsonOptions;

@SdkInternalApi
public class JsonOptionsMarshaller {
    private static final MarshallingInfo<Boolean> MULTILINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MultiLine").build();
    private static final JsonOptionsMarshaller instance = new JsonOptionsMarshaller();

    public static JsonOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(JsonOptions jsonOptions, ProtocolMarshaller protocolMarshaller) {
        if (jsonOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jsonOptions.getMultiLine(), MULTILINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

