/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gluedatabrew.model.RecipeStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateRecipeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private String name;
    private List<RecipeStep> steps;
    private Map<String, String> tags;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateRecipeRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateRecipeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<RecipeStep> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<RecipeStep> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<RecipeStep>(steps);
    }

    public CreateRecipeRequest withSteps(RecipeStep ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<RecipeStep>(steps.length));
        }
        for (RecipeStep ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public CreateRecipeRequest withSteps(Collection<RecipeStep> steps) {
        this.setSteps(steps);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateRecipeRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateRecipeRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateRecipeRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecipeRequest)) {
            return false;
        }
        CreateRecipeRequest other = (CreateRecipeRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRecipeRequest clone() {
        return (CreateRecipeRequest)super.clone();
    }
}

