/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gluedatabrew;

import javax.annotation.Generated;

import com.amazonaws.services.gluedatabrew.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGlueDataBrew}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGlueDataBrew implements AWSGlueDataBrew {

    protected AbstractAWSGlueDataBrew() {
    }

    @Override
    public BatchDeleteRecipeVersionResult batchDeleteRecipeVersion(BatchDeleteRecipeVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProfileJobResult createProfileJob(CreateProfileJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRecipeResult createRecipe(CreateRecipeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRecipeJobResult createRecipeJob(CreateRecipeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateScheduleResult createSchedule(CreateScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobResult deleteJob(DeleteJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRecipeVersionResult deleteRecipeVersion(DeleteRecipeVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteScheduleResult deleteSchedule(DeleteScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRecipeResult describeRecipe(DescribeRecipeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeScheduleResult describeSchedule(DescribeScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobRunsResult listJobRuns(ListJobRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecipeVersionsResult listRecipeVersions(ListRecipeVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRecipesResult listRecipes(ListRecipesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSchedulesResult listSchedules(ListSchedulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PublishRecipeResult publishRecipe(PublishRecipeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendProjectSessionActionResult sendProjectSessionAction(SendProjectSessionActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartJobRunResult startJobRun(StartJobRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartProjectSessionResult startProjectSession(StartProjectSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopJobRunResult stopJobRun(StopJobRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDatasetResult updateDataset(UpdateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProfileJobResult updateProfileJob(UpdateProfileJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRecipeResult updateRecipe(UpdateRecipeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRecipeJobResult updateRecipeJob(UpdateRecipeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateScheduleResult updateSchedule(UpdateScheduleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
