/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.JdbcTarget;
import com.amazonaws.services.glue.model.S3Target;
import com.amazonaws.services.glue.model.transform.CrawlerTargetsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CrawlerTargets
implements Serializable,
Cloneable,
StructuredPojo {
    private List<S3Target> s3Targets;
    private List<JdbcTarget> jdbcTargets;

    public List<S3Target> getS3Targets() {
        return this.s3Targets;
    }

    public void setS3Targets(Collection<S3Target> s3Targets) {
        if (s3Targets == null) {
            this.s3Targets = null;
            return;
        }
        this.s3Targets = new ArrayList<S3Target>(s3Targets);
    }

    public CrawlerTargets withS3Targets(S3Target ... s3Targets) {
        if (this.s3Targets == null) {
            this.setS3Targets(new ArrayList<S3Target>(s3Targets.length));
        }
        for (S3Target ele : s3Targets) {
            this.s3Targets.add(ele);
        }
        return this;
    }

    public CrawlerTargets withS3Targets(Collection<S3Target> s3Targets) {
        this.setS3Targets(s3Targets);
        return this;
    }

    public List<JdbcTarget> getJdbcTargets() {
        return this.jdbcTargets;
    }

    public void setJdbcTargets(Collection<JdbcTarget> jdbcTargets) {
        if (jdbcTargets == null) {
            this.jdbcTargets = null;
            return;
        }
        this.jdbcTargets = new ArrayList<JdbcTarget>(jdbcTargets);
    }

    public CrawlerTargets withJdbcTargets(JdbcTarget ... jdbcTargets) {
        if (this.jdbcTargets == null) {
            this.setJdbcTargets(new ArrayList<JdbcTarget>(jdbcTargets.length));
        }
        for (JdbcTarget ele : jdbcTargets) {
            this.jdbcTargets.add(ele);
        }
        return this;
    }

    public CrawlerTargets withJdbcTargets(Collection<JdbcTarget> jdbcTargets) {
        this.setJdbcTargets(jdbcTargets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Targets() != null) {
            sb.append("S3Targets: ").append(this.getS3Targets()).append(",");
        }
        if (this.getJdbcTargets() != null) {
            sb.append("JdbcTargets: ").append(this.getJdbcTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerTargets)) {
            return false;
        }
        CrawlerTargets other = (CrawlerTargets)obj;
        if (other.getS3Targets() == null ^ this.getS3Targets() == null) {
            return false;
        }
        if (other.getS3Targets() != null && !other.getS3Targets().equals(this.getS3Targets())) {
            return false;
        }
        if (other.getJdbcTargets() == null ^ this.getJdbcTargets() == null) {
            return false;
        }
        return other.getJdbcTargets() == null || other.getJdbcTargets().equals(this.getJdbcTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Targets() == null ? 0 : this.getS3Targets().hashCode());
        hashCode = 31 * hashCode + (this.getJdbcTargets() == null ? 0 : this.getJdbcTargets().hashCode());
        return hashCode;
    }

    public CrawlerTargets clone() {
        try {
            return (CrawlerTargets)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CrawlerTargetsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

