/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.globalaccelerator.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateEndpointGroupResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The information about the endpoint group that was created.
     * </p>
     */
    private EndpointGroup endpointGroup;

    /**
     * <p>
     * The information about the endpoint group that was created.
     * </p>
     * 
     * @param endpointGroup
     *        The information about the endpoint group that was created.
     */

    public void setEndpointGroup(EndpointGroup endpointGroup) {
        this.endpointGroup = endpointGroup;
    }

    /**
     * <p>
     * The information about the endpoint group that was created.
     * </p>
     * 
     * @return The information about the endpoint group that was created.
     */

    public EndpointGroup getEndpointGroup() {
        return this.endpointGroup;
    }

    /**
     * <p>
     * The information about the endpoint group that was created.
     * </p>
     * 
     * @param endpointGroup
     *        The information about the endpoint group that was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateEndpointGroupResult withEndpointGroup(EndpointGroup endpointGroup) {
        setEndpointGroup(endpointGroup);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEndpointGroup() != null)
            sb.append("EndpointGroup: ").append(getEndpointGroup());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateEndpointGroupResult == false)
            return false;
        CreateEndpointGroupResult other = (CreateEndpointGroupResult) obj;
        if (other.getEndpointGroup() == null ^ this.getEndpointGroup() == null)
            return false;
        if (other.getEndpointGroup() != null && other.getEndpointGroup().equals(this.getEndpointGroup()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEndpointGroup() == null) ? 0 : getEndpointGroup().hashCode());
        return hashCode;
    }

    @Override
    public CreateEndpointGroupResult clone() {
        try {
            return (CreateEndpointGroupResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
