/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.globalaccelerator.model.EndpointIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveEndpointsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<EndpointIdentifier> endpointIdentifiers;
    private String endpointGroupArn;

    public List<EndpointIdentifier> getEndpointIdentifiers() {
        return this.endpointIdentifiers;
    }

    public void setEndpointIdentifiers(Collection<EndpointIdentifier> endpointIdentifiers) {
        if (endpointIdentifiers == null) {
            this.endpointIdentifiers = null;
            return;
        }
        this.endpointIdentifiers = new ArrayList<EndpointIdentifier>(endpointIdentifiers);
    }

    public RemoveEndpointsRequest withEndpointIdentifiers(EndpointIdentifier ... endpointIdentifiers) {
        if (this.endpointIdentifiers == null) {
            this.setEndpointIdentifiers(new ArrayList<EndpointIdentifier>(endpointIdentifiers.length));
        }
        for (EndpointIdentifier ele : endpointIdentifiers) {
            this.endpointIdentifiers.add(ele);
        }
        return this;
    }

    public RemoveEndpointsRequest withEndpointIdentifiers(Collection<EndpointIdentifier> endpointIdentifiers) {
        this.setEndpointIdentifiers(endpointIdentifiers);
        return this;
    }

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public RemoveEndpointsRequest withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointIdentifiers() != null) {
            sb.append("EndpointIdentifiers: ").append(this.getEndpointIdentifiers()).append(",");
        }
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveEndpointsRequest)) {
            return false;
        }
        RemoveEndpointsRequest other = (RemoveEndpointsRequest)obj;
        if (other.getEndpointIdentifiers() == null ^ this.getEndpointIdentifiers() == null) {
            return false;
        }
        if (other.getEndpointIdentifiers() != null && !other.getEndpointIdentifiers().equals(this.getEndpointIdentifiers())) {
            return false;
        }
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        return other.getEndpointGroupArn() == null || other.getEndpointGroupArn().equals(this.getEndpointGroupArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointIdentifiers() == null ? 0 : this.getEndpointIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        return hashCode;
    }

    public RemoveEndpointsRequest clone() {
        return (RemoveEndpointsRequest)super.clone();
    }
}

