/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.InputSerialization;

@SdkInternalApi
public class InputSerializationMarshaller {
    private static final MarshallingInfo<StructuredPojo> CSV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("csv").build();
    private static final InputSerializationMarshaller instance = new InputSerializationMarshaller();

    public static InputSerializationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InputSerialization inputSerialization, ProtocolMarshaller protocolMarshaller) {
        if (inputSerialization == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputSerialization.getCsv(), CSV_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

