/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class UploadArchiveRequestMarshaller
implements Marshaller<Request<UploadArchiveRequest>, UploadArchiveRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UploadArchiveRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UploadArchiveRequest> marshall(UploadArchiveRequest uploadArchiveRequest) {
        if (uploadArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadArchiveRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadArchiveRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString((String)uploadArchiveRequest.getArchiveDescription()));
        }
        if (uploadArchiveRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString((String)uploadArchiveRequest.getChecksum()));
        }
        if (uploadArchiveRequest.getContentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong((Long)uploadArchiveRequest.getContentLength()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/archives";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", uploadArchiveRequest.getVaultName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", uploadArchiveRequest.getAccountId() == null ? "-" : uploadArchiveRequest.getAccountId());
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadArchiveRequest.getBody());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

