/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class UploadMultipartPartRequestMarshaller
implements Marshaller<Request<UploadMultipartPartRequest>, UploadMultipartPartRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UploadMultipartPartRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UploadMultipartPartRequest> marshall(UploadMultipartPartRequest uploadMultipartPartRequest) {
        if (uploadMultipartPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)uploadMultipartPartRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadMultipartPartRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString((String)uploadMultipartPartRequest.getChecksum()));
        }
        if (uploadMultipartPartRequest.getRange() != null) {
            request.addHeader("Content-Range", StringUtils.fromString((String)uploadMultipartPartRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", uploadMultipartPartRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)uploadMultipartPartRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", uploadMultipartPartRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)uploadMultipartPartRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{uploadId}", uploadMultipartPartRequest.getUploadId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)uploadMultipartPartRequest.getUploadId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadMultipartPartRequest.getBody());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

