/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class RemoveTagsFromVaultRequestMarshaller
implements Marshaller<Request<RemoveTagsFromVaultRequest>, RemoveTagsFromVaultRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public RemoveTagsFromVaultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RemoveTagsFromVaultRequest> marshall(RemoveTagsFromVaultRequest removeTagsFromVaultRequest) {
        if (removeTagsFromVaultRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsFromVaultRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/tags?operation=remove";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = uriResourcePath.replace("{accountId}", removeTagsFromVaultRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)removeTagsFromVaultRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", removeTagsFromVaultRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)removeTagsFromVaultRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> tagKeysList = removeTagsFromVaultRequest.getTagKeys();
            if (tagKeysList != null) {
                jsonGenerator.writeFieldName("TagKeys");
                jsonGenerator.writeStartArray();
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue == null) continue;
                    jsonGenerator.writeValue(tagKeysListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

