/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glacier.model.PartListElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPartsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String multipartUploadId;
    private String vaultARN;
    private String archiveDescription;
    private Long partSizeInBytes;
    private String creationDate;
    private List<PartListElement> parts;
    private String marker;

    public void setMultipartUploadId(String multipartUploadId) {
        this.multipartUploadId = multipartUploadId;
    }

    public String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public ListPartsResult withMultipartUploadId(String multipartUploadId) {
        this.setMultipartUploadId(multipartUploadId);
        return this;
    }

    public void setVaultARN(String vaultARN) {
        this.vaultARN = vaultARN;
    }

    public String getVaultARN() {
        return this.vaultARN;
    }

    public ListPartsResult withVaultARN(String vaultARN) {
        this.setVaultARN(vaultARN);
        return this;
    }

    public void setArchiveDescription(String archiveDescription) {
        this.archiveDescription = archiveDescription;
    }

    public String getArchiveDescription() {
        return this.archiveDescription;
    }

    public ListPartsResult withArchiveDescription(String archiveDescription) {
        this.setArchiveDescription(archiveDescription);
        return this;
    }

    public void setPartSizeInBytes(Long partSizeInBytes) {
        this.partSizeInBytes = partSizeInBytes;
    }

    public Long getPartSizeInBytes() {
        return this.partSizeInBytes;
    }

    public ListPartsResult withPartSizeInBytes(Long partSizeInBytes) {
        this.setPartSizeInBytes(partSizeInBytes);
        return this;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public ListPartsResult withCreationDate(String creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public List<PartListElement> getParts() {
        return this.parts;
    }

    public void setParts(Collection<PartListElement> parts) {
        if (parts == null) {
            this.parts = null;
            return;
        }
        this.parts = new ArrayList<PartListElement>(parts);
    }

    public ListPartsResult withParts(PartListElement ... parts) {
        if (this.parts == null) {
            this.setParts(new ArrayList<PartListElement>(parts.length));
        }
        for (PartListElement ele : parts) {
            this.parts.add(ele);
        }
        return this;
    }

    public ListPartsResult withParts(Collection<PartListElement> parts) {
        this.setParts(parts);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListPartsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMultipartUploadId() != null) {
            sb.append("MultipartUploadId: " + this.getMultipartUploadId() + ",");
        }
        if (this.getVaultARN() != null) {
            sb.append("VaultARN: " + this.getVaultARN() + ",");
        }
        if (this.getArchiveDescription() != null) {
            sb.append("ArchiveDescription: " + this.getArchiveDescription() + ",");
        }
        if (this.getPartSizeInBytes() != null) {
            sb.append("PartSizeInBytes: " + this.getPartSizeInBytes() + ",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: " + this.getCreationDate() + ",");
        }
        if (this.getParts() != null) {
            sb.append("Parts: " + this.getParts() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResult)) {
            return false;
        }
        ListPartsResult other = (ListPartsResult)obj;
        if (other.getMultipartUploadId() == null ^ this.getMultipartUploadId() == null) {
            return false;
        }
        if (other.getMultipartUploadId() != null && !other.getMultipartUploadId().equals(this.getMultipartUploadId())) {
            return false;
        }
        if (other.getVaultARN() == null ^ this.getVaultARN() == null) {
            return false;
        }
        if (other.getVaultARN() != null && !other.getVaultARN().equals(this.getVaultARN())) {
            return false;
        }
        if (other.getArchiveDescription() == null ^ this.getArchiveDescription() == null) {
            return false;
        }
        if (other.getArchiveDescription() != null && !other.getArchiveDescription().equals(this.getArchiveDescription())) {
            return false;
        }
        if (other.getPartSizeInBytes() == null ^ this.getPartSizeInBytes() == null) {
            return false;
        }
        if (other.getPartSizeInBytes() != null && !other.getPartSizeInBytes().equals(this.getPartSizeInBytes())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getParts() == null ^ this.getParts() == null) {
            return false;
        }
        if (other.getParts() != null && !other.getParts().equals(this.getParts())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMultipartUploadId() == null ? 0 : this.getMultipartUploadId().hashCode());
        hashCode = 31 * hashCode + (this.getVaultARN() == null ? 0 : this.getVaultARN().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveDescription() == null ? 0 : this.getArchiveDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPartSizeInBytes() == null ? 0 : this.getPartSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getParts() == null ? 0 : this.getParts().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public ListPartsResult clone() {
        try {
            return (ListPartsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

