/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.DefaultValueSupplier;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class CompleteMultipartUploadRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier((DefaultValueSupplier)DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> UPLOADID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("uploadId").build();
    private static final MarshallingInfo<String> ARCHIVESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-size").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").build();
    private static final CompleteMultipartUploadRequestMarshaller instance = new CompleteMultipartUploadRequestMarshaller();

    public static CompleteMultipartUploadRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CompleteMultipartUploadRequest completeMultipartUploadRequest, ProtocolMarshaller protocolMarshaller) {
        if (completeMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.getUploadId(), UPLOADID_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.getArchiveSize(), ARCHIVESIZE_BINDING);
            protocolMarshaller.marshall((Object)completeMultipartUploadRequest.getChecksum(), CHECKSUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

