/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListMultipartUploadsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMultipartUploadsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads";
        uriResourcePath = uriResourcePath.replace("{accountId}", listMultipartUploadsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listMultipartUploadsRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", listMultipartUploadsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listMultipartUploadsRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (listMultipartUploadsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString((String)listMultipartUploadsRequest.getLimit()));
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listMultipartUploadsRequest.getUploadIdMarker()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

