/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamesparks;

import javax.annotation.Generated;

import com.amazonaws.services.gamesparks.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSGameSparks}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSGameSparks implements AWSGameSparks {

    protected AbstractAWSGameSparks() {
    }

    @Override
    public CreateGameResult createGame(CreateGameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateStageResult createStage(CreateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGameResult deleteGame(DeleteGameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteStageResult deleteStage(DeleteStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisconnectPlayerResult disconnectPlayer(DisconnectPlayerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExportSnapshotResult exportSnapshot(ExportSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExtensionResult getExtension(GetExtensionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExtensionVersionResult getExtensionVersion(GetExtensionVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGameResult getGame(GetGameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGameConfigurationResult getGameConfiguration(GetGameConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGeneratedCodeJobResult getGeneratedCodeJob(GetGeneratedCodeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPlayerConnectionStatusResult getPlayerConnectionStatus(GetPlayerConnectionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSnapshotResult getSnapshot(GetSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStageResult getStage(GetStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetStageDeploymentResult getStageDeployment(GetStageDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportGameConfigurationResult importGameConfiguration(ImportGameConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExtensionVersionsResult listExtensionVersions(ListExtensionVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExtensionsResult listExtensions(ListExtensionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGamesResult listGames(ListGamesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGeneratedCodeJobsResult listGeneratedCodeJobs(ListGeneratedCodeJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSnapshotsResult listSnapshots(ListSnapshotsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStageDeploymentsResult listStageDeployments(ListStageDeploymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStagesResult listStages(ListStagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartGeneratedCodeJobResult startGeneratedCodeJob(StartGeneratedCodeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartStageDeploymentResult startStageDeployment(StartStageDeploymentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameResult updateGame(UpdateGameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGameConfigurationResult updateGameConfiguration(UpdateGameConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSnapshotResult updateSnapshot(UpdateSnapshotRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStageResult updateStage(UpdateStageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
