/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamesparks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gamesparks.model.Generator;

@SdkInternalApi
public class GeneratorMarshaller {
    private static final MarshallingInfo<String> GAMESDKVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GameSdkVersion").build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Language").build();
    private static final MarshallingInfo<String> TARGETPLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetPlatform").build();
    private static final GeneratorMarshaller instance = new GeneratorMarshaller();

    public static GeneratorMarshaller getInstance() {
        return instance;
    }

    public void marshall(Generator generator, ProtocolMarshaller protocolMarshaller) {
        if (generator == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)generator.getGameSdkVersion(), GAMESDKVERSION_BINDING);
            protocolMarshaller.marshall((Object)generator.getLanguage(), LANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)generator.getTargetPlatform(), TARGETPLATFORM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

