/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.gamelift.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ContainerGroupsConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ContainerGroupsConfigurationMarshaller {

    private static final MarshallingInfo<List> CONTAINERGROUPDEFINITIONNAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContainerGroupDefinitionNames").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONPORTRANGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionPortRange").build();
    private static final MarshallingInfo<Integer> DESIREDREPLICACONTAINERGROUPSPERINSTANCE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredReplicaContainerGroupsPerInstance").build();

    private static final ContainerGroupsConfigurationMarshaller instance = new ContainerGroupsConfigurationMarshaller();

    public static ContainerGroupsConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ContainerGroupsConfiguration containerGroupsConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (containerGroupsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(containerGroupsConfiguration.getContainerGroupDefinitionNames(), CONTAINERGROUPDEFINITIONNAMES_BINDING);
            protocolMarshaller.marshall(containerGroupsConfiguration.getConnectionPortRange(), CONNECTIONPORTRANGE_BINDING);
            protocolMarshaller.marshall(containerGroupsConfiguration.getDesiredReplicaContainerGroupsPerInstance(),
                    DESIREDREPLICACONTAINERGROUPSPERINSTANCE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
