/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.gamelift.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeComputeResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The set of properties for the requested compute resource.
     * </p>
     */
    private Compute compute;

    /**
     * <p>
     * The set of properties for the requested compute resource.
     * </p>
     * 
     * @param compute
     *        The set of properties for the requested compute resource.
     */

    public void setCompute(Compute compute) {
        this.compute = compute;
    }

    /**
     * <p>
     * The set of properties for the requested compute resource.
     * </p>
     * 
     * @return The set of properties for the requested compute resource.
     */

    public Compute getCompute() {
        return this.compute;
    }

    /**
     * <p>
     * The set of properties for the requested compute resource.
     * </p>
     * 
     * @param compute
     *        The set of properties for the requested compute resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeComputeResult withCompute(Compute compute) {
        setCompute(compute);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCompute() != null)
            sb.append("Compute: ").append(getCompute());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeComputeResult == false)
            return false;
        DescribeComputeResult other = (DescribeComputeResult) obj;
        if (other.getCompute() == null ^ this.getCompute() == null)
            return false;
        if (other.getCompute() != null && other.getCompute().equals(this.getCompute()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCompute() == null) ? 0 : getCompute().hashCode());
        return hashCode;
    }

    @Override
    public DescribeComputeResult clone() {
        try {
            return (DescribeComputeResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
