/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.GameSessionQueueDestination;
import com.amazonaws.services.gamelift.model.PlayerLatencyPolicy;
import com.amazonaws.services.gamelift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGameSessionQueueRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private Integer timeoutInSeconds;
    private List<PlayerLatencyPolicy> playerLatencyPolicies;
    private List<GameSessionQueueDestination> destinations;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateGameSessionQueueRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public CreateGameSessionQueueRequest withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.setTimeoutInSeconds(timeoutInSeconds);
        return this;
    }

    public List<PlayerLatencyPolicy> getPlayerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
        if (playerLatencyPolicies == null) {
            this.playerLatencyPolicies = null;
            return;
        }
        this.playerLatencyPolicies = new ArrayList<PlayerLatencyPolicy>(playerLatencyPolicies);
    }

    public CreateGameSessionQueueRequest withPlayerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
        if (this.playerLatencyPolicies == null) {
            this.setPlayerLatencyPolicies(new ArrayList<PlayerLatencyPolicy>(playerLatencyPolicies.length));
        }
        for (PlayerLatencyPolicy ele : playerLatencyPolicies) {
            this.playerLatencyPolicies.add(ele);
        }
        return this;
    }

    public CreateGameSessionQueueRequest withPlayerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
        this.setPlayerLatencyPolicies(playerLatencyPolicies);
        return this;
    }

    public List<GameSessionQueueDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<GameSessionQueueDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<GameSessionQueueDestination>(destinations);
    }

    public CreateGameSessionQueueRequest withDestinations(GameSessionQueueDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<GameSessionQueueDestination>(destinations.length));
        }
        for (GameSessionQueueDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public CreateGameSessionQueueRequest withDestinations(Collection<GameSessionQueueDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateGameSessionQueueRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateGameSessionQueueRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTimeoutInSeconds() != null) {
            sb.append("TimeoutInSeconds: ").append(this.getTimeoutInSeconds()).append(",");
        }
        if (this.getPlayerLatencyPolicies() != null) {
            sb.append("PlayerLatencyPolicies: ").append(this.getPlayerLatencyPolicies()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionQueueRequest)) {
            return false;
        }
        CreateGameSessionQueueRequest other = (CreateGameSessionQueueRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTimeoutInSeconds() == null ^ this.getTimeoutInSeconds() == null) {
            return false;
        }
        if (other.getTimeoutInSeconds() != null && !other.getTimeoutInSeconds().equals(this.getTimeoutInSeconds())) {
            return false;
        }
        if (other.getPlayerLatencyPolicies() == null ^ this.getPlayerLatencyPolicies() == null) {
            return false;
        }
        if (other.getPlayerLatencyPolicies() != null && !other.getPlayerLatencyPolicies().equals(this.getPlayerLatencyPolicies())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInSeconds() == null ? 0 : this.getTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerLatencyPolicies() == null ? 0 : this.getPlayerLatencyPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateGameSessionQueueRequest clone() {
        return (CreateGameSessionQueueRequest)super.clone();
    }
}

