/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.services.fsx.model.FileSystem;
import com.amazonaws.services.fsx.model.transform.AdministrativeActionJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.FileSystemFailureDetailsJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.LustreFileSystemConfigurationJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.OntapFileSystemConfigurationJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.TagJsonUnmarshaller;
import com.amazonaws.services.fsx.model.transform.WindowsFileSystemConfigurationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class FileSystemJsonUnmarshaller
implements Unmarshaller<FileSystem, JsonUnmarshallerContext> {
    private static FileSystemJsonUnmarshaller instance;

    public FileSystem unmarshall(JsonUnmarshallerContext context) throws Exception {
        FileSystem fileSystem = new FileSystem();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setOwnerId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    fileSystem.setCreationTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFileSystemId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FileSystemType", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFileSystemType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Lifecycle", targetDepth)) {
                    context.nextToken();
                    fileSystem.setLifecycle((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FailureDetails", targetDepth)) {
                    context.nextToken();
                    fileSystem.setFailureDetails(FileSystemFailureDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StorageCapacity", targetDepth)) {
                    context.nextToken();
                    fileSystem.setStorageCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StorageType", targetDepth)) {
                    context.nextToken();
                    fileSystem.setStorageType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setVpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubnetIds", targetDepth)) {
                    context.nextToken();
                    fileSystem.setSubnetIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("NetworkInterfaceIds", targetDepth)) {
                    context.nextToken();
                    fileSystem.setNetworkInterfaceIds(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("DNSName", targetDepth)) {
                    context.nextToken();
                    fileSystem.setDNSName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    fileSystem.setKmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceARN", targetDepth)) {
                    context.nextToken();
                    fileSystem.setResourceARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    fileSystem.setTags(new ListUnmarshaller((Unmarshaller)TagJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("WindowsConfiguration", targetDepth)) {
                    context.nextToken();
                    fileSystem.setWindowsConfiguration(WindowsFileSystemConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LustreConfiguration", targetDepth)) {
                    context.nextToken();
                    fileSystem.setLustreConfiguration(LustreFileSystemConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AdministrativeActions", targetDepth)) {
                    context.nextToken();
                    fileSystem.setAdministrativeActions(new ListUnmarshaller((Unmarshaller)AdministrativeActionJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("OntapConfiguration", targetDepth)) {
                    context.nextToken();
                    fileSystem.setOntapConfiguration(OntapFileSystemConfigurationJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return fileSystem;
    }

    public static FileSystemJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemJsonUnmarshaller();
        }
        return instance;
    }
}

