/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.transform.OpenZFSClientConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenZFSClientConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String clients;
    private List<String> options;

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getClients() {
        return this.clients;
    }

    public OpenZFSClientConfiguration withClients(String clients) {
        this.setClients(clients);
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(Collection<String> options) {
        if (options == null) {
            this.options = null;
            return;
        }
        this.options = new ArrayList<String>(options);
    }

    public OpenZFSClientConfiguration withOptions(String ... options) {
        if (this.options == null) {
            this.setOptions(new ArrayList<String>(options.length));
        }
        for (String ele : options) {
            this.options.add(ele);
        }
        return this;
    }

    public OpenZFSClientConfiguration withOptions(Collection<String> options) {
        this.setOptions(options);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClients() != null) {
            sb.append("Clients: ").append(this.getClients()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSClientConfiguration)) {
            return false;
        }
        OpenZFSClientConfiguration other = (OpenZFSClientConfiguration)obj;
        if (other.getClients() == null ^ this.getClients() == null) {
            return false;
        }
        if (other.getClients() != null && !other.getClients().equals(this.getClients())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClients() == null ? 0 : this.getClients().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public OpenZFSClientConfiguration clone() {
        try {
            return (OpenZFSClientConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenZFSClientConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

