/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.LabelSchema;
import com.amazonaws.services.frauddetector.model.transform.TrainingDataSchemaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrainingDataSchema
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> modelVariables;
    private LabelSchema labelSchema;

    public List<String> getModelVariables() {
        return this.modelVariables;
    }

    public void setModelVariables(Collection<String> modelVariables) {
        if (modelVariables == null) {
            this.modelVariables = null;
            return;
        }
        this.modelVariables = new ArrayList<String>(modelVariables);
    }

    public TrainingDataSchema withModelVariables(String ... modelVariables) {
        if (this.modelVariables == null) {
            this.setModelVariables(new ArrayList<String>(modelVariables.length));
        }
        for (String ele : modelVariables) {
            this.modelVariables.add(ele);
        }
        return this;
    }

    public TrainingDataSchema withModelVariables(Collection<String> modelVariables) {
        this.setModelVariables(modelVariables);
        return this;
    }

    public void setLabelSchema(LabelSchema labelSchema) {
        this.labelSchema = labelSchema;
    }

    public LabelSchema getLabelSchema() {
        return this.labelSchema;
    }

    public TrainingDataSchema withLabelSchema(LabelSchema labelSchema) {
        this.setLabelSchema(labelSchema);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelVariables() != null) {
            sb.append("ModelVariables: ").append(this.getModelVariables()).append(",");
        }
        if (this.getLabelSchema() != null) {
            sb.append("LabelSchema: ").append(this.getLabelSchema());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataSchema)) {
            return false;
        }
        TrainingDataSchema other = (TrainingDataSchema)obj;
        if (other.getModelVariables() == null ^ this.getModelVariables() == null) {
            return false;
        }
        if (other.getModelVariables() != null && !other.getModelVariables().equals(this.getModelVariables())) {
            return false;
        }
        if (other.getLabelSchema() == null ^ this.getLabelSchema() == null) {
            return false;
        }
        return other.getLabelSchema() == null || other.getLabelSchema().equals(this.getLabelSchema());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelVariables() == null ? 0 : this.getModelVariables().hashCode());
        hashCode = 31 * hashCode + (this.getLabelSchema() == null ? 0 : this.getLabelSchema().hashCode());
        return hashCode;
    }

    public TrainingDataSchema clone() {
        try {
            return (TrainingDataSchema)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingDataSchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

