/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.frauddetector;

import javax.annotation.Generated;

import com.amazonaws.services.frauddetector.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonFraudDetector}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonFraudDetector implements AmazonFraudDetector {

    protected AbstractAmazonFraudDetector() {
    }

    @Override
    public BatchCreateVariableResult batchCreateVariable(BatchCreateVariableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetVariableResult batchGetVariable(BatchGetVariableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelBatchImportJobResult cancelBatchImportJob(CancelBatchImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelBatchPredictionJobResult cancelBatchPredictionJob(CancelBatchPredictionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBatchImportJobResult createBatchImportJob(CreateBatchImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateBatchPredictionJobResult createBatchPredictionJob(CreateBatchPredictionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDetectorVersionResult createDetectorVersion(CreateDetectorVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateModelVersionResult createModelVersion(CreateModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRuleResult createRule(CreateRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVariableResult createVariable(CreateVariableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBatchImportJobResult deleteBatchImportJob(DeleteBatchImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteBatchPredictionJobResult deleteBatchPredictionJob(DeleteBatchPredictionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDetectorResult deleteDetector(DeleteDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDetectorVersionResult deleteDetectorVersion(DeleteDetectorVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEntityTypeResult deleteEntityType(DeleteEntityTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventResult deleteEvent(DeleteEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventTypeResult deleteEventType(DeleteEventTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEventsByEventTypeResult deleteEventsByEventType(DeleteEventsByEventTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExternalModelResult deleteExternalModel(DeleteExternalModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLabelResult deleteLabel(DeleteLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteModelVersionResult deleteModelVersion(DeleteModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOutcomeResult deleteOutcome(DeleteOutcomeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVariableResult deleteVariable(DeleteVariableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDetectorResult describeDetector(DescribeDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeModelVersionsResult describeModelVersions(DescribeModelVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBatchImportJobsResult getBatchImportJobs(GetBatchImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBatchPredictionJobsResult getBatchPredictionJobs(GetBatchPredictionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDeleteEventsByEventTypeStatusResult getDeleteEventsByEventTypeStatus(GetDeleteEventsByEventTypeStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDetectorVersionResult getDetectorVersion(GetDetectorVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDetectorsResult getDetectors(GetDetectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEntityTypesResult getEntityTypes(GetEntityTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventResult getEvent(GetEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventPredictionResult getEventPrediction(GetEventPredictionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventPredictionMetadataResult getEventPredictionMetadata(GetEventPredictionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEventTypesResult getEventTypes(GetEventTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExternalModelsResult getExternalModels(GetExternalModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetKMSEncryptionKeyResult getKMSEncryptionKey(GetKMSEncryptionKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLabelsResult getLabels(GetLabelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelVersionResult getModelVersion(GetModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetModelsResult getModels(GetModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOutcomesResult getOutcomes(GetOutcomesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRulesResult getRules(GetRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVariablesResult getVariables(GetVariablesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventPredictionsResult listEventPredictions(ListEventPredictionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDetectorResult putDetector(PutDetectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEntityTypeResult putEntityType(PutEntityTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEventTypeResult putEventType(PutEventTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutExternalModelResult putExternalModel(PutExternalModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutKMSEncryptionKeyResult putKMSEncryptionKey(PutKMSEncryptionKeyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutLabelResult putLabel(PutLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutOutcomeResult putOutcome(PutOutcomeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendEventResult sendEvent(SendEventRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDetectorVersionResult updateDetectorVersion(UpdateDetectorVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDetectorVersionMetadataResult updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDetectorVersionStatusResult updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEventLabelResult updateEventLabel(UpdateEventLabelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelResult updateModel(UpdateModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelVersionResult updateModelVersion(UpdateModelVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateModelVersionStatusResult updateModelVersionStatus(UpdateModelVersionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuleMetadataResult updateRuleMetadata(UpdateRuleMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuleVersionResult updateRuleVersion(UpdateRuleVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVariableResult updateVariable(UpdateVariableRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
