/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ModelInputDataFormat;
import com.amazonaws.services.frauddetector.model.transform.ModelInputConfigurationMarshaller;
import java.io.Serializable;

public class ModelInputConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventTypeName;
    private String format;
    private Boolean useEventVariables;
    private String jsonInputTemplate;
    private String csvInputTemplate;

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public ModelInputConfiguration withEventTypeName(String eventTypeName) {
        this.setEventTypeName(eventTypeName);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ModelInputConfiguration withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ModelInputConfiguration withFormat(ModelInputDataFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setUseEventVariables(Boolean useEventVariables) {
        this.useEventVariables = useEventVariables;
    }

    public Boolean getUseEventVariables() {
        return this.useEventVariables;
    }

    public ModelInputConfiguration withUseEventVariables(Boolean useEventVariables) {
        this.setUseEventVariables(useEventVariables);
        return this;
    }

    public Boolean isUseEventVariables() {
        return this.useEventVariables;
    }

    public void setJsonInputTemplate(String jsonInputTemplate) {
        this.jsonInputTemplate = jsonInputTemplate;
    }

    public String getJsonInputTemplate() {
        return this.jsonInputTemplate;
    }

    public ModelInputConfiguration withJsonInputTemplate(String jsonInputTemplate) {
        this.setJsonInputTemplate(jsonInputTemplate);
        return this;
    }

    public void setCsvInputTemplate(String csvInputTemplate) {
        this.csvInputTemplate = csvInputTemplate;
    }

    public String getCsvInputTemplate() {
        return this.csvInputTemplate;
    }

    public ModelInputConfiguration withCsvInputTemplate(String csvInputTemplate) {
        this.setCsvInputTemplate(csvInputTemplate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventTypeName() != null) {
            sb.append("EventTypeName: ").append(this.getEventTypeName()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getUseEventVariables() != null) {
            sb.append("UseEventVariables: ").append(this.getUseEventVariables()).append(",");
        }
        if (this.getJsonInputTemplate() != null) {
            sb.append("JsonInputTemplate: ").append(this.getJsonInputTemplate()).append(",");
        }
        if (this.getCsvInputTemplate() != null) {
            sb.append("CsvInputTemplate: ").append(this.getCsvInputTemplate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInputConfiguration)) {
            return false;
        }
        ModelInputConfiguration other = (ModelInputConfiguration)obj;
        if (other.getEventTypeName() == null ^ this.getEventTypeName() == null) {
            return false;
        }
        if (other.getEventTypeName() != null && !other.getEventTypeName().equals(this.getEventTypeName())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getUseEventVariables() == null ^ this.getUseEventVariables() == null) {
            return false;
        }
        if (other.getUseEventVariables() != null && !other.getUseEventVariables().equals(this.getUseEventVariables())) {
            return false;
        }
        if (other.getJsonInputTemplate() == null ^ this.getJsonInputTemplate() == null) {
            return false;
        }
        if (other.getJsonInputTemplate() != null && !other.getJsonInputTemplate().equals(this.getJsonInputTemplate())) {
            return false;
        }
        if (other.getCsvInputTemplate() == null ^ this.getCsvInputTemplate() == null) {
            return false;
        }
        return other.getCsvInputTemplate() == null || other.getCsvInputTemplate().equals(this.getCsvInputTemplate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventTypeName() == null ? 0 : this.getEventTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getUseEventVariables() == null ? 0 : this.getUseEventVariables().hashCode());
        hashCode = 31 * hashCode + (this.getJsonInputTemplate() == null ? 0 : this.getJsonInputTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getCsvInputTemplate() == null ? 0 : this.getCsvInputTemplate().hashCode());
        return hashCode;
    }

    public ModelInputConfiguration clone() {
        try {
            return (ModelInputConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModelInputConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

