/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.LabelSchema;
import com.amazonaws.services.frauddetector.model.ModelTypeEnum;
import com.amazonaws.services.frauddetector.model.ModelVariable;
import com.amazonaws.services.frauddetector.model.TrainingDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutModelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelId;
    private String modelType;
    private String description;
    private TrainingDataSource trainingDataSource;
    private List<ModelVariable> modelVariables;
    private LabelSchema labelSchema;

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public PutModelRequest withModelId(String modelId) {
        this.setModelId(modelId);
        return this;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getModelType() {
        return this.modelType;
    }

    public PutModelRequest withModelType(String modelType) {
        this.setModelType(modelType);
        return this;
    }

    public PutModelRequest withModelType(ModelTypeEnum modelType) {
        this.modelType = modelType.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public PutModelRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTrainingDataSource(TrainingDataSource trainingDataSource) {
        this.trainingDataSource = trainingDataSource;
    }

    public TrainingDataSource getTrainingDataSource() {
        return this.trainingDataSource;
    }

    public PutModelRequest withTrainingDataSource(TrainingDataSource trainingDataSource) {
        this.setTrainingDataSource(trainingDataSource);
        return this;
    }

    public List<ModelVariable> getModelVariables() {
        return this.modelVariables;
    }

    public void setModelVariables(Collection<ModelVariable> modelVariables) {
        if (modelVariables == null) {
            this.modelVariables = null;
            return;
        }
        this.modelVariables = new ArrayList<ModelVariable>(modelVariables);
    }

    public PutModelRequest withModelVariables(ModelVariable ... modelVariables) {
        if (this.modelVariables == null) {
            this.setModelVariables(new ArrayList<ModelVariable>(modelVariables.length));
        }
        for (ModelVariable ele : modelVariables) {
            this.modelVariables.add(ele);
        }
        return this;
    }

    public PutModelRequest withModelVariables(Collection<ModelVariable> modelVariables) {
        this.setModelVariables(modelVariables);
        return this;
    }

    public void setLabelSchema(LabelSchema labelSchema) {
        this.labelSchema = labelSchema;
    }

    public LabelSchema getLabelSchema() {
        return this.labelSchema;
    }

    public PutModelRequest withLabelSchema(LabelSchema labelSchema) {
        this.setLabelSchema(labelSchema);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelId() != null) {
            sb.append("ModelId: ").append(this.getModelId()).append(",");
        }
        if (this.getModelType() != null) {
            sb.append("ModelType: ").append(this.getModelType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTrainingDataSource() != null) {
            sb.append("TrainingDataSource: ").append(this.getTrainingDataSource()).append(",");
        }
        if (this.getModelVariables() != null) {
            sb.append("ModelVariables: ").append(this.getModelVariables()).append(",");
        }
        if (this.getLabelSchema() != null) {
            sb.append("LabelSchema: ").append(this.getLabelSchema());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutModelRequest)) {
            return false;
        }
        PutModelRequest other = (PutModelRequest)obj;
        if (other.getModelId() == null ^ this.getModelId() == null) {
            return false;
        }
        if (other.getModelId() != null && !other.getModelId().equals(this.getModelId())) {
            return false;
        }
        if (other.getModelType() == null ^ this.getModelType() == null) {
            return false;
        }
        if (other.getModelType() != null && !other.getModelType().equals(this.getModelType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTrainingDataSource() == null ^ this.getTrainingDataSource() == null) {
            return false;
        }
        if (other.getTrainingDataSource() != null && !other.getTrainingDataSource().equals(this.getTrainingDataSource())) {
            return false;
        }
        if (other.getModelVariables() == null ^ this.getModelVariables() == null) {
            return false;
        }
        if (other.getModelVariables() != null && !other.getModelVariables().equals(this.getModelVariables())) {
            return false;
        }
        if (other.getLabelSchema() == null ^ this.getLabelSchema() == null) {
            return false;
        }
        return other.getLabelSchema() == null || other.getLabelSchema().equals(this.getLabelSchema());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelId() == null ? 0 : this.getModelId().hashCode());
        hashCode = 31 * hashCode + (this.getModelType() == null ? 0 : this.getModelType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingDataSource() == null ? 0 : this.getTrainingDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getModelVariables() == null ? 0 : this.getModelVariables().hashCode());
        hashCode = 31 * hashCode + (this.getLabelSchema() == null ? 0 : this.getLabelSchema().hashCode());
        return hashCode;
    }

    public PutModelRequest clone() {
        return (PutModelRequest)super.clone();
    }
}

