/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecastquery;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.forecastquery.AmazonForecastQueryAsync;
import com.amazonaws.services.forecastquery.AmazonForecastQueryAsyncClientBuilder;
import com.amazonaws.services.forecastquery.AmazonForecastQueryClient;
import com.amazonaws.services.forecastquery.model.QueryForecastRequest;
import com.amazonaws.services.forecastquery.model.QueryForecastResult;
import com.amazonaws.services.forecastquery.model.QueryWhatIfForecastRequest;
import com.amazonaws.services.forecastquery.model.QueryWhatIfForecastResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonForecastQueryAsyncClient
extends AmazonForecastQueryClient
implements AmazonForecastQueryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonForecastQueryAsyncClientBuilder asyncBuilder() {
        return AmazonForecastQueryAsyncClientBuilder.standard();
    }

    AmazonForecastQueryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonForecastQueryAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<QueryForecastResult> queryForecastAsync(QueryForecastRequest request) {
        return this.queryForecastAsync(request, null);
    }

    @Override
    public Future<QueryForecastResult> queryForecastAsync(QueryForecastRequest request, final AsyncHandler<QueryForecastRequest, QueryForecastResult> asyncHandler) {
        final QueryForecastRequest finalRequest = (QueryForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryForecastResult>(){

            @Override
            public QueryForecastResult call() throws Exception {
                QueryForecastResult result = null;
                try {
                    result = AmazonForecastQueryAsyncClient.this.executeQueryForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<QueryWhatIfForecastResult> queryWhatIfForecastAsync(QueryWhatIfForecastRequest request) {
        return this.queryWhatIfForecastAsync(request, null);
    }

    @Override
    public Future<QueryWhatIfForecastResult> queryWhatIfForecastAsync(QueryWhatIfForecastRequest request, final AsyncHandler<QueryWhatIfForecastRequest, QueryWhatIfForecastResult> asyncHandler) {
        final QueryWhatIfForecastRequest finalRequest = (QueryWhatIfForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<QueryWhatIfForecastResult>(){

            @Override
            public QueryWhatIfForecastResult call() throws Exception {
                QueryWhatIfForecastResult result = null;
                try {
                    result = AmazonForecastQueryAsyncClient.this.executeQueryWhatIfForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

