/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.DataConfig;
import java.util.List;

@SdkInternalApi
public class DataConfigMarshaller {
    private static final MarshallingInfo<String> DATASETGROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetGroupArn").build();
    private static final MarshallingInfo<List> ATTRIBUTECONFIGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeConfigs").build();
    private static final MarshallingInfo<List> ADDITIONALDATASETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalDatasets").build();
    private static final DataConfigMarshaller instance = new DataConfigMarshaller();

    public static DataConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataConfig dataConfig, ProtocolMarshaller protocolMarshaller) {
        if (dataConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataConfig.getDatasetGroupArn(), DATASETGROUPARN_BINDING);
            protocolMarshaller.marshall(dataConfig.getAttributeConfigs(), ATTRIBUTECONFIGS_BINDING);
            protocolMarshaller.marshall(dataConfig.getAdditionalDatasets(), ADDITIONALDATASETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

