/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.forecast.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeWhatIfAnalysisResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeWhatIfAnalysisResultJsonUnmarshaller implements Unmarshaller<DescribeWhatIfAnalysisResult, JsonUnmarshallerContext> {

    public DescribeWhatIfAnalysisResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeWhatIfAnalysisResult describeWhatIfAnalysisResult = new DescribeWhatIfAnalysisResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeWhatIfAnalysisResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WhatIfAnalysisName", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setWhatIfAnalysisName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("WhatIfAnalysisArn", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setWhatIfAnalysisArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ForecastArn", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setForecastArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EstimatedTimeRemainingInMinutes", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setEstimatedTimeRemainingInMinutes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Message", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setMessage(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setCreationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("LastModificationTime", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setLastModificationTime(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("TimeSeriesSelector", targetDepth)) {
                    context.nextToken();
                    describeWhatIfAnalysisResult.setTimeSeriesSelector(TimeSeriesSelectorJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeWhatIfAnalysisResult;
    }

    private static DescribeWhatIfAnalysisResultJsonUnmarshaller instance;

    public static DescribeWhatIfAnalysisResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeWhatIfAnalysisResultJsonUnmarshaller();
        return instance;
    }
}
