/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.ErrorMetric;

@SdkInternalApi
public class ErrorMetricMarshaller {
    private static final MarshallingInfo<String> FORECASTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastType").build();
    private static final MarshallingInfo<Double> WAPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WAPE").build();
    private static final MarshallingInfo<Double> RMSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RMSE").build();
    private static final ErrorMetricMarshaller instance = new ErrorMetricMarshaller();

    public static ErrorMetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(ErrorMetric errorMetric, ProtocolMarshaller protocolMarshaller) {
        if (errorMetric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)errorMetric.getForecastType(), FORECASTTYPE_BINDING);
            protocolMarshaller.marshall((Object)errorMetric.getWAPE(), WAPE_BINDING);
            protocolMarshaller.marshall((Object)errorMetric.getRMSE(), RMSE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

