/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.ResourceSetStatus;
import com.amazonaws.services.fms.model.transform.ResourceSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private String description;
    private String updateToken;
    private List<String> resourceTypeList;
    private Date lastUpdateTime;
    private String resourceSetStatus;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ResourceSet withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceSet withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourceSet withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setUpdateToken(String updateToken) {
        this.updateToken = updateToken;
    }

    public String getUpdateToken() {
        return this.updateToken;
    }

    public ResourceSet withUpdateToken(String updateToken) {
        this.setUpdateToken(updateToken);
        return this;
    }

    public List<String> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public void setResourceTypeList(Collection<String> resourceTypeList) {
        if (resourceTypeList == null) {
            this.resourceTypeList = null;
            return;
        }
        this.resourceTypeList = new ArrayList<String>(resourceTypeList);
    }

    public ResourceSet withResourceTypeList(String ... resourceTypeList) {
        if (this.resourceTypeList == null) {
            this.setResourceTypeList(new ArrayList<String>(resourceTypeList.length));
        }
        for (String ele : resourceTypeList) {
            this.resourceTypeList.add(ele);
        }
        return this;
    }

    public ResourceSet withResourceTypeList(Collection<String> resourceTypeList) {
        this.setResourceTypeList(resourceTypeList);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public ResourceSet withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public void setResourceSetStatus(String resourceSetStatus) {
        this.resourceSetStatus = resourceSetStatus;
    }

    public String getResourceSetStatus() {
        return this.resourceSetStatus;
    }

    public ResourceSet withResourceSetStatus(String resourceSetStatus) {
        this.setResourceSetStatus(resourceSetStatus);
        return this;
    }

    public ResourceSet withResourceSetStatus(ResourceSetStatus resourceSetStatus) {
        this.resourceSetStatus = resourceSetStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getUpdateToken() != null) {
            sb.append("UpdateToken: ").append(this.getUpdateToken()).append(",");
        }
        if (this.getResourceTypeList() != null) {
            sb.append("ResourceTypeList: ").append(this.getResourceTypeList()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime()).append(",");
        }
        if (this.getResourceSetStatus() != null) {
            sb.append("ResourceSetStatus: ").append(this.getResourceSetStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSet)) {
            return false;
        }
        ResourceSet other = (ResourceSet)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getUpdateToken() == null ^ this.getUpdateToken() == null) {
            return false;
        }
        if (other.getUpdateToken() != null && !other.getUpdateToken().equals(this.getUpdateToken())) {
            return false;
        }
        if (other.getResourceTypeList() == null ^ this.getResourceTypeList() == null) {
            return false;
        }
        if (other.getResourceTypeList() != null && !other.getResourceTypeList().equals(this.getResourceTypeList())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        if (other.getLastUpdateTime() != null && !other.getLastUpdateTime().equals(this.getLastUpdateTime())) {
            return false;
        }
        if (other.getResourceSetStatus() == null ^ this.getResourceSetStatus() == null) {
            return false;
        }
        return other.getResourceSetStatus() == null || other.getResourceSetStatus().equals(this.getResourceSetStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateToken() == null ? 0 : this.getUpdateToken().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypeList() == null ? 0 : this.getResourceTypeList().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSetStatus() == null ? 0 : this.getResourceSetStatus().hashCode());
        return hashCode;
    }

    public ResourceSet clone() {
        try {
            return (ResourceSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

