/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fms.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutProtocolsList" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PutProtocolsListResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The details of the Firewall Manager protocols list.
     * </p>
     */
    private ProtocolsListData protocolsList;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protocols list.
     * </p>
     */
    private String protocolsListArn;

    /**
     * <p>
     * The details of the Firewall Manager protocols list.
     * </p>
     * 
     * @param protocolsList
     *        The details of the Firewall Manager protocols list.
     */

    public void setProtocolsList(ProtocolsListData protocolsList) {
        this.protocolsList = protocolsList;
    }

    /**
     * <p>
     * The details of the Firewall Manager protocols list.
     * </p>
     * 
     * @return The details of the Firewall Manager protocols list.
     */

    public ProtocolsListData getProtocolsList() {
        return this.protocolsList;
    }

    /**
     * <p>
     * The details of the Firewall Manager protocols list.
     * </p>
     * 
     * @param protocolsList
     *        The details of the Firewall Manager protocols list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutProtocolsListResult withProtocolsList(ProtocolsListData protocolsList) {
        setProtocolsList(protocolsList);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protocols list.
     * </p>
     * 
     * @param protocolsListArn
     *        The Amazon Resource Name (ARN) of the protocols list.
     */

    public void setProtocolsListArn(String protocolsListArn) {
        this.protocolsListArn = protocolsListArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protocols list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the protocols list.
     */

    public String getProtocolsListArn() {
        return this.protocolsListArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the protocols list.
     * </p>
     * 
     * @param protocolsListArn
     *        The Amazon Resource Name (ARN) of the protocols list.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PutProtocolsListResult withProtocolsListArn(String protocolsListArn) {
        setProtocolsListArn(protocolsListArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProtocolsList() != null)
            sb.append("ProtocolsList: ").append(getProtocolsList()).append(",");
        if (getProtocolsListArn() != null)
            sb.append("ProtocolsListArn: ").append(getProtocolsListArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PutProtocolsListResult == false)
            return false;
        PutProtocolsListResult other = (PutProtocolsListResult) obj;
        if (other.getProtocolsList() == null ^ this.getProtocolsList() == null)
            return false;
        if (other.getProtocolsList() != null && other.getProtocolsList().equals(this.getProtocolsList()) == false)
            return false;
        if (other.getProtocolsListArn() == null ^ this.getProtocolsListArn() == null)
            return false;
        if (other.getProtocolsListArn() != null && other.getProtocolsListArn().equals(this.getProtocolsListArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProtocolsList() == null) ? 0 : getProtocolsList().hashCode());
        hashCode = prime * hashCode + ((getProtocolsListArn() == null) ? 0 : getProtocolsListArn().hashCode());
        return hashCode;
    }

    @Override
    public PutProtocolsListResult clone() {
        try {
            return (PutProtocolsListResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
