/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.fms.AWSFMSAsync;
import com.amazonaws.services.fms.AWSFMSAsyncClientBuilder;
import com.amazonaws.services.fms.AWSFMSClient;
import com.amazonaws.services.fms.model.AssociateAdminAccountRequest;
import com.amazonaws.services.fms.model.AssociateAdminAccountResult;
import com.amazonaws.services.fms.model.DeleteAppsListRequest;
import com.amazonaws.services.fms.model.DeleteAppsListResult;
import com.amazonaws.services.fms.model.DeleteNotificationChannelRequest;
import com.amazonaws.services.fms.model.DeleteNotificationChannelResult;
import com.amazonaws.services.fms.model.DeletePolicyRequest;
import com.amazonaws.services.fms.model.DeletePolicyResult;
import com.amazonaws.services.fms.model.DeleteProtocolsListRequest;
import com.amazonaws.services.fms.model.DeleteProtocolsListResult;
import com.amazonaws.services.fms.model.DisassociateAdminAccountRequest;
import com.amazonaws.services.fms.model.DisassociateAdminAccountResult;
import com.amazonaws.services.fms.model.GetAdminAccountRequest;
import com.amazonaws.services.fms.model.GetAdminAccountResult;
import com.amazonaws.services.fms.model.GetAppsListRequest;
import com.amazonaws.services.fms.model.GetAppsListResult;
import com.amazonaws.services.fms.model.GetComplianceDetailRequest;
import com.amazonaws.services.fms.model.GetComplianceDetailResult;
import com.amazonaws.services.fms.model.GetNotificationChannelRequest;
import com.amazonaws.services.fms.model.GetNotificationChannelResult;
import com.amazonaws.services.fms.model.GetPolicyRequest;
import com.amazonaws.services.fms.model.GetPolicyResult;
import com.amazonaws.services.fms.model.GetProtectionStatusRequest;
import com.amazonaws.services.fms.model.GetProtectionStatusResult;
import com.amazonaws.services.fms.model.GetProtocolsListRequest;
import com.amazonaws.services.fms.model.GetProtocolsListResult;
import com.amazonaws.services.fms.model.GetViolationDetailsRequest;
import com.amazonaws.services.fms.model.GetViolationDetailsResult;
import com.amazonaws.services.fms.model.ListAppsListsRequest;
import com.amazonaws.services.fms.model.ListAppsListsResult;
import com.amazonaws.services.fms.model.ListComplianceStatusRequest;
import com.amazonaws.services.fms.model.ListComplianceStatusResult;
import com.amazonaws.services.fms.model.ListMemberAccountsRequest;
import com.amazonaws.services.fms.model.ListMemberAccountsResult;
import com.amazonaws.services.fms.model.ListPoliciesRequest;
import com.amazonaws.services.fms.model.ListPoliciesResult;
import com.amazonaws.services.fms.model.ListProtocolsListsRequest;
import com.amazonaws.services.fms.model.ListProtocolsListsResult;
import com.amazonaws.services.fms.model.ListTagsForResourceRequest;
import com.amazonaws.services.fms.model.ListTagsForResourceResult;
import com.amazonaws.services.fms.model.PutAppsListRequest;
import com.amazonaws.services.fms.model.PutAppsListResult;
import com.amazonaws.services.fms.model.PutNotificationChannelRequest;
import com.amazonaws.services.fms.model.PutNotificationChannelResult;
import com.amazonaws.services.fms.model.PutPolicyRequest;
import com.amazonaws.services.fms.model.PutPolicyResult;
import com.amazonaws.services.fms.model.PutProtocolsListRequest;
import com.amazonaws.services.fms.model.PutProtocolsListResult;
import com.amazonaws.services.fms.model.TagResourceRequest;
import com.amazonaws.services.fms.model.TagResourceResult;
import com.amazonaws.services.fms.model.UntagResourceRequest;
import com.amazonaws.services.fms.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFMSAsyncClient
extends AWSFMSClient
implements AWSFMSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFMSAsyncClientBuilder asyncBuilder() {
        return AWSFMSAsyncClientBuilder.standard();
    }

    AWSFMSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFMSAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateAdminAccountResult> associateAdminAccountAsync(AssociateAdminAccountRequest request) {
        return this.associateAdminAccountAsync(request, null);
    }

    @Override
    public Future<AssociateAdminAccountResult> associateAdminAccountAsync(AssociateAdminAccountRequest request, final AsyncHandler<AssociateAdminAccountRequest, AssociateAdminAccountResult> asyncHandler) {
        final AssociateAdminAccountRequest finalRequest = (AssociateAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateAdminAccountResult>(){

            @Override
            public AssociateAdminAccountResult call() throws Exception {
                AssociateAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeAssociateAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAppsListResult> deleteAppsListAsync(DeleteAppsListRequest request) {
        return this.deleteAppsListAsync(request, null);
    }

    @Override
    public Future<DeleteAppsListResult> deleteAppsListAsync(DeleteAppsListRequest request, final AsyncHandler<DeleteAppsListRequest, DeleteAppsListResult> asyncHandler) {
        final DeleteAppsListRequest finalRequest = (DeleteAppsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAppsListResult>(){

            @Override
            public DeleteAppsListResult call() throws Exception {
                DeleteAppsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeleteAppsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteNotificationChannelResult> deleteNotificationChannelAsync(DeleteNotificationChannelRequest request) {
        return this.deleteNotificationChannelAsync(request, null);
    }

    @Override
    public Future<DeleteNotificationChannelResult> deleteNotificationChannelAsync(DeleteNotificationChannelRequest request, final AsyncHandler<DeleteNotificationChannelRequest, DeleteNotificationChannelResult> asyncHandler) {
        final DeleteNotificationChannelRequest finalRequest = (DeleteNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteNotificationChannelResult>(){

            @Override
            public DeleteNotificationChannelResult call() throws Exception {
                DeleteNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeleteNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, DeletePolicyResult> asyncHandler) {
        final DeletePolicyRequest finalRequest = (DeletePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePolicyResult>(){

            @Override
            public DeletePolicyResult call() throws Exception {
                DeletePolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeletePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProtocolsListResult> deleteProtocolsListAsync(DeleteProtocolsListRequest request) {
        return this.deleteProtocolsListAsync(request, null);
    }

    @Override
    public Future<DeleteProtocolsListResult> deleteProtocolsListAsync(DeleteProtocolsListRequest request, final AsyncHandler<DeleteProtocolsListRequest, DeleteProtocolsListResult> asyncHandler) {
        final DeleteProtocolsListRequest finalRequest = (DeleteProtocolsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProtocolsListResult>(){

            @Override
            public DeleteProtocolsListResult call() throws Exception {
                DeleteProtocolsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDeleteProtocolsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateAdminAccountResult> disassociateAdminAccountAsync(DisassociateAdminAccountRequest request) {
        return this.disassociateAdminAccountAsync(request, null);
    }

    @Override
    public Future<DisassociateAdminAccountResult> disassociateAdminAccountAsync(DisassociateAdminAccountRequest request, final AsyncHandler<DisassociateAdminAccountRequest, DisassociateAdminAccountResult> asyncHandler) {
        final DisassociateAdminAccountRequest finalRequest = (DisassociateAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateAdminAccountResult>(){

            @Override
            public DisassociateAdminAccountResult call() throws Exception {
                DisassociateAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeDisassociateAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAdminAccountResult> getAdminAccountAsync(GetAdminAccountRequest request) {
        return this.getAdminAccountAsync(request, null);
    }

    @Override
    public Future<GetAdminAccountResult> getAdminAccountAsync(GetAdminAccountRequest request, final AsyncHandler<GetAdminAccountRequest, GetAdminAccountResult> asyncHandler) {
        final GetAdminAccountRequest finalRequest = (GetAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAdminAccountResult>(){

            @Override
            public GetAdminAccountResult call() throws Exception {
                GetAdminAccountResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAppsListResult> getAppsListAsync(GetAppsListRequest request) {
        return this.getAppsListAsync(request, null);
    }

    @Override
    public Future<GetAppsListResult> getAppsListAsync(GetAppsListRequest request, final AsyncHandler<GetAppsListRequest, GetAppsListResult> asyncHandler) {
        final GetAppsListRequest finalRequest = (GetAppsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAppsListResult>(){

            @Override
            public GetAppsListResult call() throws Exception {
                GetAppsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetAppsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceDetailResult> getComplianceDetailAsync(GetComplianceDetailRequest request) {
        return this.getComplianceDetailAsync(request, null);
    }

    @Override
    public Future<GetComplianceDetailResult> getComplianceDetailAsync(GetComplianceDetailRequest request, final AsyncHandler<GetComplianceDetailRequest, GetComplianceDetailResult> asyncHandler) {
        final GetComplianceDetailRequest finalRequest = (GetComplianceDetailRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetComplianceDetailResult>(){

            @Override
            public GetComplianceDetailResult call() throws Exception {
                GetComplianceDetailResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetComplianceDetail(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNotificationChannelResult> getNotificationChannelAsync(GetNotificationChannelRequest request) {
        return this.getNotificationChannelAsync(request, null);
    }

    @Override
    public Future<GetNotificationChannelResult> getNotificationChannelAsync(GetNotificationChannelRequest request, final AsyncHandler<GetNotificationChannelRequest, GetNotificationChannelResult> asyncHandler) {
        final GetNotificationChannelRequest finalRequest = (GetNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNotificationChannelResult>(){

            @Override
            public GetNotificationChannelResult call() throws Exception {
                GetNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request) {
        return this.getPolicyAsync(request, null);
    }

    @Override
    public Future<GetPolicyResult> getPolicyAsync(GetPolicyRequest request, final AsyncHandler<GetPolicyRequest, GetPolicyResult> asyncHandler) {
        final GetPolicyRequest finalRequest = (GetPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPolicyResult>(){

            @Override
            public GetPolicyResult call() throws Exception {
                GetPolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProtectionStatusResult> getProtectionStatusAsync(GetProtectionStatusRequest request) {
        return this.getProtectionStatusAsync(request, null);
    }

    @Override
    public Future<GetProtectionStatusResult> getProtectionStatusAsync(GetProtectionStatusRequest request, final AsyncHandler<GetProtectionStatusRequest, GetProtectionStatusResult> asyncHandler) {
        final GetProtectionStatusRequest finalRequest = (GetProtectionStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProtectionStatusResult>(){

            @Override
            public GetProtectionStatusResult call() throws Exception {
                GetProtectionStatusResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetProtectionStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProtocolsListResult> getProtocolsListAsync(GetProtocolsListRequest request) {
        return this.getProtocolsListAsync(request, null);
    }

    @Override
    public Future<GetProtocolsListResult> getProtocolsListAsync(GetProtocolsListRequest request, final AsyncHandler<GetProtocolsListRequest, GetProtocolsListResult> asyncHandler) {
        final GetProtocolsListRequest finalRequest = (GetProtocolsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProtocolsListResult>(){

            @Override
            public GetProtocolsListResult call() throws Exception {
                GetProtocolsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetProtocolsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetViolationDetailsResult> getViolationDetailsAsync(GetViolationDetailsRequest request) {
        return this.getViolationDetailsAsync(request, null);
    }

    @Override
    public Future<GetViolationDetailsResult> getViolationDetailsAsync(GetViolationDetailsRequest request, final AsyncHandler<GetViolationDetailsRequest, GetViolationDetailsResult> asyncHandler) {
        final GetViolationDetailsRequest finalRequest = (GetViolationDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetViolationDetailsResult>(){

            @Override
            public GetViolationDetailsResult call() throws Exception {
                GetViolationDetailsResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeGetViolationDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppsListsResult> listAppsListsAsync(ListAppsListsRequest request) {
        return this.listAppsListsAsync(request, null);
    }

    @Override
    public Future<ListAppsListsResult> listAppsListsAsync(ListAppsListsRequest request, final AsyncHandler<ListAppsListsRequest, ListAppsListsResult> asyncHandler) {
        final ListAppsListsRequest finalRequest = (ListAppsListsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAppsListsResult>(){

            @Override
            public ListAppsListsResult call() throws Exception {
                ListAppsListsResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListAppsLists(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListComplianceStatusResult> listComplianceStatusAsync(ListComplianceStatusRequest request) {
        return this.listComplianceStatusAsync(request, null);
    }

    @Override
    public Future<ListComplianceStatusResult> listComplianceStatusAsync(ListComplianceStatusRequest request, final AsyncHandler<ListComplianceStatusRequest, ListComplianceStatusResult> asyncHandler) {
        final ListComplianceStatusRequest finalRequest = (ListComplianceStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListComplianceStatusResult>(){

            @Override
            public ListComplianceStatusResult call() throws Exception {
                ListComplianceStatusResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListComplianceStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request) {
        return this.listMemberAccountsAsync(request, null);
    }

    @Override
    public Future<ListMemberAccountsResult> listMemberAccountsAsync(ListMemberAccountsRequest request, final AsyncHandler<ListMemberAccountsRequest, ListMemberAccountsResult> asyncHandler) {
        final ListMemberAccountsRequest finalRequest = (ListMemberAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMemberAccountsResult>(){

            @Override
            public ListMemberAccountsResult call() throws Exception {
                ListMemberAccountsResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListMemberAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request) {
        return this.listPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request, final AsyncHandler<ListPoliciesRequest, ListPoliciesResult> asyncHandler) {
        final ListPoliciesRequest finalRequest = (ListPoliciesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPoliciesResult>(){

            @Override
            public ListPoliciesResult call() throws Exception {
                ListPoliciesResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProtocolsListsResult> listProtocolsListsAsync(ListProtocolsListsRequest request) {
        return this.listProtocolsListsAsync(request, null);
    }

    @Override
    public Future<ListProtocolsListsResult> listProtocolsListsAsync(ListProtocolsListsRequest request, final AsyncHandler<ListProtocolsListsRequest, ListProtocolsListsResult> asyncHandler) {
        final ListProtocolsListsRequest finalRequest = (ListProtocolsListsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProtocolsListsResult>(){

            @Override
            public ListProtocolsListsResult call() throws Exception {
                ListProtocolsListsResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListProtocolsLists(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAppsListResult> putAppsListAsync(PutAppsListRequest request) {
        return this.putAppsListAsync(request, null);
    }

    @Override
    public Future<PutAppsListResult> putAppsListAsync(PutAppsListRequest request, final AsyncHandler<PutAppsListRequest, PutAppsListResult> asyncHandler) {
        final PutAppsListRequest finalRequest = (PutAppsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAppsListResult>(){

            @Override
            public PutAppsListResult call() throws Exception {
                PutAppsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutAppsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutNotificationChannelResult> putNotificationChannelAsync(PutNotificationChannelRequest request) {
        return this.putNotificationChannelAsync(request, null);
    }

    @Override
    public Future<PutNotificationChannelResult> putNotificationChannelAsync(PutNotificationChannelRequest request, final AsyncHandler<PutNotificationChannelRequest, PutNotificationChannelResult> asyncHandler) {
        final PutNotificationChannelRequest finalRequest = (PutNotificationChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutNotificationChannelResult>(){

            @Override
            public PutNotificationChannelResult call() throws Exception {
                PutNotificationChannelResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutNotificationChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request) {
        return this.putPolicyAsync(request, null);
    }

    @Override
    public Future<PutPolicyResult> putPolicyAsync(PutPolicyRequest request, final AsyncHandler<PutPolicyRequest, PutPolicyResult> asyncHandler) {
        final PutPolicyRequest finalRequest = (PutPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPolicyResult>(){

            @Override
            public PutPolicyResult call() throws Exception {
                PutPolicyResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutProtocolsListResult> putProtocolsListAsync(PutProtocolsListRequest request) {
        return this.putProtocolsListAsync(request, null);
    }

    @Override
    public Future<PutProtocolsListResult> putProtocolsListAsync(PutProtocolsListRequest request, final AsyncHandler<PutProtocolsListRequest, PutProtocolsListResult> asyncHandler) {
        final PutProtocolsListRequest finalRequest = (PutProtocolsListRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutProtocolsListResult>(){

            @Override
            public PutProtocolsListResult call() throws Exception {
                PutProtocolsListResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executePutProtocolsList(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSFMSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

