/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.fis;

import javax.annotation.Generated;

import com.amazonaws.services.fis.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSFIS}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSFIS implements AWSFIS {

    protected AbstractAWSFIS() {
    }

    @Override
    public CreateExperimentTemplateResult createExperimentTemplate(CreateExperimentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTargetAccountConfigurationResult createTargetAccountConfiguration(CreateTargetAccountConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteExperimentTemplateResult deleteExperimentTemplate(DeleteExperimentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTargetAccountConfigurationResult deleteTargetAccountConfiguration(DeleteTargetAccountConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetActionResult getAction(GetActionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExperimentResult getExperiment(GetExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExperimentTargetAccountConfigurationResult getExperimentTargetAccountConfiguration(GetExperimentTargetAccountConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetExperimentTemplateResult getExperimentTemplate(GetExperimentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTargetAccountConfigurationResult getTargetAccountConfiguration(GetTargetAccountConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTargetResourceTypeResult getTargetResourceType(GetTargetResourceTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListActionsResult listActions(ListActionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentResolvedTargetsResult listExperimentResolvedTargets(ListExperimentResolvedTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentTargetAccountConfigurationsResult listExperimentTargetAccountConfigurations(ListExperimentTargetAccountConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentTemplatesResult listExperimentTemplates(ListExperimentTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListExperimentsResult listExperiments(ListExperimentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetAccountConfigurationsResult listTargetAccountConfigurations(ListTargetAccountConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetResourceTypesResult listTargetResourceTypes(ListTargetResourceTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartExperimentResult startExperiment(StartExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopExperimentResult stopExperiment(StopExperimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExperimentTemplateResult updateExperimentTemplate(UpdateExperimentTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTargetAccountConfigurationResult updateTargetAccountConfiguration(UpdateTargetAccountConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
