/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsync;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataAsyncClientBuilder;
import com.amazonaws.services.finspacedata.AWSFinSpaceDataClient;
import com.amazonaws.services.finspacedata.model.CreateChangesetRequest;
import com.amazonaws.services.finspacedata.model.CreateChangesetResult;
import com.amazonaws.services.finspacedata.model.CreateDataViewRequest;
import com.amazonaws.services.finspacedata.model.CreateDataViewResult;
import com.amazonaws.services.finspacedata.model.CreateDatasetRequest;
import com.amazonaws.services.finspacedata.model.CreateDatasetResult;
import com.amazonaws.services.finspacedata.model.DeleteDatasetRequest;
import com.amazonaws.services.finspacedata.model.DeleteDatasetResult;
import com.amazonaws.services.finspacedata.model.GetChangesetRequest;
import com.amazonaws.services.finspacedata.model.GetChangesetResult;
import com.amazonaws.services.finspacedata.model.GetDataViewRequest;
import com.amazonaws.services.finspacedata.model.GetDataViewResult;
import com.amazonaws.services.finspacedata.model.GetDatasetRequest;
import com.amazonaws.services.finspacedata.model.GetDatasetResult;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest;
import com.amazonaws.services.finspacedata.model.GetProgrammaticAccessCredentialsResult;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationRequest;
import com.amazonaws.services.finspacedata.model.GetWorkingLocationResult;
import com.amazonaws.services.finspacedata.model.ListChangesetsRequest;
import com.amazonaws.services.finspacedata.model.ListChangesetsResult;
import com.amazonaws.services.finspacedata.model.ListDataViewsRequest;
import com.amazonaws.services.finspacedata.model.ListDataViewsResult;
import com.amazonaws.services.finspacedata.model.ListDatasetsRequest;
import com.amazonaws.services.finspacedata.model.ListDatasetsResult;
import com.amazonaws.services.finspacedata.model.UpdateChangesetRequest;
import com.amazonaws.services.finspacedata.model.UpdateChangesetResult;
import com.amazonaws.services.finspacedata.model.UpdateDatasetRequest;
import com.amazonaws.services.finspacedata.model.UpdateDatasetResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFinSpaceDataAsyncClient
extends AWSFinSpaceDataClient
implements AWSFinSpaceDataAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFinSpaceDataAsyncClientBuilder asyncBuilder() {
        return AWSFinSpaceDataAsyncClientBuilder.standard();
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFinSpaceDataAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request) {
        return this.createChangesetAsync(request, null);
    }

    @Override
    public Future<CreateChangesetResult> createChangesetAsync(CreateChangesetRequest request, final AsyncHandler<CreateChangesetRequest, CreateChangesetResult> asyncHandler) {
        final CreateChangesetRequest finalRequest = (CreateChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChangesetResult>(){

            @Override
            public CreateChangesetResult call() throws Exception {
                CreateChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataViewResult> createDataViewAsync(CreateDataViewRequest request) {
        return this.createDataViewAsync(request, null);
    }

    @Override
    public Future<CreateDataViewResult> createDataViewAsync(CreateDataViewRequest request, final AsyncHandler<CreateDataViewRequest, CreateDataViewResult> asyncHandler) {
        final CreateDataViewRequest finalRequest = (CreateDataViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataViewResult>(){

            @Override
            public CreateDataViewResult call() throws Exception {
                CreateDataViewResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateDataView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetAsync(request, null);
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request, final AsyncHandler<CreateDatasetRequest, CreateDatasetResult> asyncHandler) {
        final CreateDatasetRequest finalRequest = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetResult>(){

            @Override
            public CreateDatasetResult call() throws Exception {
                CreateDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeCreateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChangesetResult> getChangesetAsync(GetChangesetRequest request) {
        return this.getChangesetAsync(request, null);
    }

    @Override
    public Future<GetChangesetResult> getChangesetAsync(GetChangesetRequest request, final AsyncHandler<GetChangesetRequest, GetChangesetResult> asyncHandler) {
        final GetChangesetRequest finalRequest = (GetChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetChangesetResult>(){

            @Override
            public GetChangesetResult call() throws Exception {
                GetChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataViewResult> getDataViewAsync(GetDataViewRequest request) {
        return this.getDataViewAsync(request, null);
    }

    @Override
    public Future<GetDataViewResult> getDataViewAsync(GetDataViewRequest request, final AsyncHandler<GetDataViewRequest, GetDataViewResult> asyncHandler) {
        final GetDataViewRequest finalRequest = (GetDataViewRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataViewResult>(){

            @Override
            public GetDataViewResult call() throws Exception {
                GetDataViewResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetDataView(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatasetResult> getDatasetAsync(GetDatasetRequest request) {
        return this.getDatasetAsync(request, null);
    }

    @Override
    public Future<GetDatasetResult> getDatasetAsync(GetDatasetRequest request, final AsyncHandler<GetDatasetRequest, GetDatasetResult> asyncHandler) {
        final GetDatasetRequest finalRequest = (GetDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatasetResult>(){

            @Override
            public GetDatasetResult call() throws Exception {
                GetDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request) {
        return this.getProgrammaticAccessCredentialsAsync(request, null);
    }

    @Override
    public Future<GetProgrammaticAccessCredentialsResult> getProgrammaticAccessCredentialsAsync(GetProgrammaticAccessCredentialsRequest request, final AsyncHandler<GetProgrammaticAccessCredentialsRequest, GetProgrammaticAccessCredentialsResult> asyncHandler) {
        final GetProgrammaticAccessCredentialsRequest finalRequest = (GetProgrammaticAccessCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProgrammaticAccessCredentialsResult>(){

            @Override
            public GetProgrammaticAccessCredentialsResult call() throws Exception {
                GetProgrammaticAccessCredentialsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetProgrammaticAccessCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request) {
        return this.getWorkingLocationAsync(request, null);
    }

    @Override
    public Future<GetWorkingLocationResult> getWorkingLocationAsync(GetWorkingLocationRequest request, final AsyncHandler<GetWorkingLocationRequest, GetWorkingLocationResult> asyncHandler) {
        final GetWorkingLocationRequest finalRequest = (GetWorkingLocationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkingLocationResult>(){

            @Override
            public GetWorkingLocationResult call() throws Exception {
                GetWorkingLocationResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeGetWorkingLocation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangesetsResult> listChangesetsAsync(ListChangesetsRequest request) {
        return this.listChangesetsAsync(request, null);
    }

    @Override
    public Future<ListChangesetsResult> listChangesetsAsync(ListChangesetsRequest request, final AsyncHandler<ListChangesetsRequest, ListChangesetsResult> asyncHandler) {
        final ListChangesetsRequest finalRequest = (ListChangesetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangesetsResult>(){

            @Override
            public ListChangesetsResult call() throws Exception {
                ListChangesetsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListChangesets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataViewsResult> listDataViewsAsync(ListDataViewsRequest request) {
        return this.listDataViewsAsync(request, null);
    }

    @Override
    public Future<ListDataViewsResult> listDataViewsAsync(ListDataViewsRequest request, final AsyncHandler<ListDataViewsRequest, ListDataViewsResult> asyncHandler) {
        final ListDataViewsRequest finalRequest = (ListDataViewsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataViewsResult>(){

            @Override
            public ListDataViewsResult call() throws Exception {
                ListDataViewsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListDataViews(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChangesetResult> updateChangesetAsync(UpdateChangesetRequest request) {
        return this.updateChangesetAsync(request, null);
    }

    @Override
    public Future<UpdateChangesetResult> updateChangesetAsync(UpdateChangesetRequest request, final AsyncHandler<UpdateChangesetRequest, UpdateChangesetResult> asyncHandler) {
        final UpdateChangesetRequest finalRequest = (UpdateChangesetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChangesetResult>(){

            @Override
            public UpdateChangesetResult call() throws Exception {
                UpdateChangesetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdateChangeset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request) {
        return this.updateDatasetAsync(request, null);
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request, final AsyncHandler<UpdateDatasetRequest, UpdateDatasetResult> asyncHandler) {
        final UpdateDatasetRequest finalRequest = (UpdateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDatasetResult>(){

            @Override
            public UpdateDatasetResult call() throws Exception {
                UpdateDatasetResult result = null;
                try {
                    result = AWSFinSpaceDataAsyncClient.this.executeUpdateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

