/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.finspace.model.KxNode;
import java.util.Date;

@SdkInternalApi
public class KxNodeMarshaller {
    private static final MarshallingInfo<String> NODEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeId").build();
    private static final MarshallingInfo<String> AVAILABILITYZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZoneId").build();
    private static final MarshallingInfo<Date> LAUNCHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final KxNodeMarshaller instance = new KxNodeMarshaller();

    public static KxNodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(KxNode kxNode, ProtocolMarshaller protocolMarshaller) {
        if (kxNode == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kxNode.getNodeId(), NODEID_BINDING);
            protocolMarshaller.marshall((Object)kxNode.getAvailabilityZoneId(), AVAILABILITYZONEID_BINDING);
            protocolMarshaller.marshall((Object)kxNode.getLaunchTime(), LAUNCHTIME_BINDING);
            protocolMarshaller.marshall((Object)kxNode.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

