/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cloudwatchevents.model.EventSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEventSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<EventSource> eventSources;
    private String nextToken;

    public List<EventSource> getEventSources() {
        return this.eventSources;
    }

    public void setEventSources(Collection<EventSource> eventSources) {
        if (eventSources == null) {
            this.eventSources = null;
            return;
        }
        this.eventSources = new ArrayList<EventSource>(eventSources);
    }

    public ListEventSourcesResult withEventSources(EventSource ... eventSources) {
        if (this.eventSources == null) {
            this.setEventSources(new ArrayList<EventSource>(eventSources.length));
        }
        for (EventSource ele : eventSources) {
            this.eventSources.add(ele);
        }
        return this;
    }

    public ListEventSourcesResult withEventSources(Collection<EventSource> eventSources) {
        this.setEventSources(eventSources);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEventSourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventSources() != null) {
            sb.append("EventSources: ").append(this.getEventSources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourcesResult)) {
            return false;
        }
        ListEventSourcesResult other = (ListEventSourcesResult)obj;
        if (other.getEventSources() == null ^ this.getEventSources() == null) {
            return false;
        }
        if (other.getEventSources() != null && !other.getEventSources().equals(this.getEventSources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventSources() == null ? 0 : this.getEventSources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListEventSourcesResult clone() {
        try {
            return (ListEventSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

