/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.Archive;
import java.util.Date;

@SdkInternalApi
public class ArchiveMarshaller {
    private static final MarshallingInfo<String> ARCHIVENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchiveName").build();
    private static final MarshallingInfo<String> EVENTSOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSourceArn").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateReason").build();
    private static final MarshallingInfo<Integer> RETENTIONDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetentionDays").build();
    private static final MarshallingInfo<Long> SIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeBytes").build();
    private static final MarshallingInfo<Long> EVENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventCount").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final ArchiveMarshaller instance = new ArchiveMarshaller();

    public static ArchiveMarshaller getInstance() {
        return instance;
    }

    public void marshall(Archive archive, ProtocolMarshaller protocolMarshaller) {
        if (archive == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)archive.getArchiveName(), ARCHIVENAME_BINDING);
            protocolMarshaller.marshall((Object)archive.getEventSourceArn(), EVENTSOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)archive.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)archive.getStateReason(), STATEREASON_BINDING);
            protocolMarshaller.marshall((Object)archive.getRetentionDays(), RETENTIONDAYS_BINDING);
            protocolMarshaller.marshall((Object)archive.getSizeBytes(), SIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)archive.getEventCount(), EVENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)archive.getCreationTime(), CREATIONTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

