/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.eventbridge.AmazonEventBridgeAsync;
import com.amazonaws.services.eventbridge.AmazonEventBridgeAsyncClientBuilder;
import com.amazonaws.services.eventbridge.AmazonEventBridgeClient;
import com.amazonaws.services.eventbridge.model.ActivateEventSourceRequest;
import com.amazonaws.services.eventbridge.model.ActivateEventSourceResult;
import com.amazonaws.services.eventbridge.model.CancelReplayRequest;
import com.amazonaws.services.eventbridge.model.CancelReplayResult;
import com.amazonaws.services.eventbridge.model.CreateArchiveRequest;
import com.amazonaws.services.eventbridge.model.CreateArchiveResult;
import com.amazonaws.services.eventbridge.model.CreateEventBusRequest;
import com.amazonaws.services.eventbridge.model.CreateEventBusResult;
import com.amazonaws.services.eventbridge.model.CreatePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.CreatePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeactivateEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DeactivateEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeleteArchiveRequest;
import com.amazonaws.services.eventbridge.model.DeleteArchiveResult;
import com.amazonaws.services.eventbridge.model.DeleteEventBusRequest;
import com.amazonaws.services.eventbridge.model.DeleteEventBusResult;
import com.amazonaws.services.eventbridge.model.DeletePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DeletePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeleteRuleRequest;
import com.amazonaws.services.eventbridge.model.DeleteRuleResult;
import com.amazonaws.services.eventbridge.model.DescribeArchiveRequest;
import com.amazonaws.services.eventbridge.model.DescribeArchiveResult;
import com.amazonaws.services.eventbridge.model.DescribeEventBusRequest;
import com.amazonaws.services.eventbridge.model.DescribeEventBusResult;
import com.amazonaws.services.eventbridge.model.DescribeEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DescribeEventSourceResult;
import com.amazonaws.services.eventbridge.model.DescribePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DescribePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DescribeReplayRequest;
import com.amazonaws.services.eventbridge.model.DescribeReplayResult;
import com.amazonaws.services.eventbridge.model.DescribeRuleRequest;
import com.amazonaws.services.eventbridge.model.DescribeRuleResult;
import com.amazonaws.services.eventbridge.model.DisableRuleRequest;
import com.amazonaws.services.eventbridge.model.DisableRuleResult;
import com.amazonaws.services.eventbridge.model.EnableRuleRequest;
import com.amazonaws.services.eventbridge.model.EnableRuleResult;
import com.amazonaws.services.eventbridge.model.ListArchivesRequest;
import com.amazonaws.services.eventbridge.model.ListArchivesResult;
import com.amazonaws.services.eventbridge.model.ListEventBusesRequest;
import com.amazonaws.services.eventbridge.model.ListEventBusesResult;
import com.amazonaws.services.eventbridge.model.ListEventSourcesRequest;
import com.amazonaws.services.eventbridge.model.ListEventSourcesResult;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourceAccountsRequest;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourceAccountsResult;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourcesRequest;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourcesResult;
import com.amazonaws.services.eventbridge.model.ListReplaysRequest;
import com.amazonaws.services.eventbridge.model.ListReplaysResult;
import com.amazonaws.services.eventbridge.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.eventbridge.model.ListRuleNamesByTargetResult;
import com.amazonaws.services.eventbridge.model.ListRulesRequest;
import com.amazonaws.services.eventbridge.model.ListRulesResult;
import com.amazonaws.services.eventbridge.model.ListTagsForResourceRequest;
import com.amazonaws.services.eventbridge.model.ListTagsForResourceResult;
import com.amazonaws.services.eventbridge.model.ListTargetsByRuleRequest;
import com.amazonaws.services.eventbridge.model.ListTargetsByRuleResult;
import com.amazonaws.services.eventbridge.model.PutEventsRequest;
import com.amazonaws.services.eventbridge.model.PutEventsResult;
import com.amazonaws.services.eventbridge.model.PutPartnerEventsRequest;
import com.amazonaws.services.eventbridge.model.PutPartnerEventsResult;
import com.amazonaws.services.eventbridge.model.PutPermissionRequest;
import com.amazonaws.services.eventbridge.model.PutPermissionResult;
import com.amazonaws.services.eventbridge.model.PutRuleRequest;
import com.amazonaws.services.eventbridge.model.PutRuleResult;
import com.amazonaws.services.eventbridge.model.PutTargetsRequest;
import com.amazonaws.services.eventbridge.model.PutTargetsResult;
import com.amazonaws.services.eventbridge.model.RemovePermissionRequest;
import com.amazonaws.services.eventbridge.model.RemovePermissionResult;
import com.amazonaws.services.eventbridge.model.RemoveTargetsRequest;
import com.amazonaws.services.eventbridge.model.RemoveTargetsResult;
import com.amazonaws.services.eventbridge.model.StartReplayRequest;
import com.amazonaws.services.eventbridge.model.StartReplayResult;
import com.amazonaws.services.eventbridge.model.TagResourceRequest;
import com.amazonaws.services.eventbridge.model.TagResourceResult;
import com.amazonaws.services.eventbridge.model.TestEventPatternRequest;
import com.amazonaws.services.eventbridge.model.TestEventPatternResult;
import com.amazonaws.services.eventbridge.model.UntagResourceRequest;
import com.amazonaws.services.eventbridge.model.UntagResourceResult;
import com.amazonaws.services.eventbridge.model.UpdateArchiveRequest;
import com.amazonaws.services.eventbridge.model.UpdateArchiveResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEventBridgeAsyncClient
extends AmazonEventBridgeClient
implements AmazonEventBridgeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEventBridgeAsyncClientBuilder asyncBuilder() {
        return AmazonEventBridgeAsyncClientBuilder.standard();
    }

    AmazonEventBridgeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonEventBridgeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ActivateEventSourceResult> activateEventSourceAsync(ActivateEventSourceRequest request) {
        return this.activateEventSourceAsync(request, null);
    }

    @Override
    public Future<ActivateEventSourceResult> activateEventSourceAsync(ActivateEventSourceRequest request, final AsyncHandler<ActivateEventSourceRequest, ActivateEventSourceResult> asyncHandler) {
        final ActivateEventSourceRequest finalRequest = (ActivateEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivateEventSourceResult>(){

            @Override
            public ActivateEventSourceResult call() throws Exception {
                ActivateEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeActivateEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelReplayResult> cancelReplayAsync(CancelReplayRequest request) {
        return this.cancelReplayAsync(request, null);
    }

    @Override
    public Future<CancelReplayResult> cancelReplayAsync(CancelReplayRequest request, final AsyncHandler<CancelReplayRequest, CancelReplayResult> asyncHandler) {
        final CancelReplayRequest finalRequest = (CancelReplayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelReplayResult>(){

            @Override
            public CancelReplayResult call() throws Exception {
                CancelReplayResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeCancelReplay(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateArchiveResult> createArchiveAsync(CreateArchiveRequest request) {
        return this.createArchiveAsync(request, null);
    }

    @Override
    public Future<CreateArchiveResult> createArchiveAsync(CreateArchiveRequest request, final AsyncHandler<CreateArchiveRequest, CreateArchiveResult> asyncHandler) {
        final CreateArchiveRequest finalRequest = (CreateArchiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateArchiveResult>(){

            @Override
            public CreateArchiveResult call() throws Exception {
                CreateArchiveResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeCreateArchive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEventBusResult> createEventBusAsync(CreateEventBusRequest request) {
        return this.createEventBusAsync(request, null);
    }

    @Override
    public Future<CreateEventBusResult> createEventBusAsync(CreateEventBusRequest request, final AsyncHandler<CreateEventBusRequest, CreateEventBusResult> asyncHandler) {
        final CreateEventBusRequest finalRequest = (CreateEventBusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEventBusResult>(){

            @Override
            public CreateEventBusResult call() throws Exception {
                CreateEventBusResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeCreateEventBus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePartnerEventSourceResult> createPartnerEventSourceAsync(CreatePartnerEventSourceRequest request) {
        return this.createPartnerEventSourceAsync(request, null);
    }

    @Override
    public Future<CreatePartnerEventSourceResult> createPartnerEventSourceAsync(CreatePartnerEventSourceRequest request, final AsyncHandler<CreatePartnerEventSourceRequest, CreatePartnerEventSourceResult> asyncHandler) {
        final CreatePartnerEventSourceRequest finalRequest = (CreatePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePartnerEventSourceResult>(){

            @Override
            public CreatePartnerEventSourceResult call() throws Exception {
                CreatePartnerEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeCreatePartnerEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivateEventSourceResult> deactivateEventSourceAsync(DeactivateEventSourceRequest request) {
        return this.deactivateEventSourceAsync(request, null);
    }

    @Override
    public Future<DeactivateEventSourceResult> deactivateEventSourceAsync(DeactivateEventSourceRequest request, final AsyncHandler<DeactivateEventSourceRequest, DeactivateEventSourceResult> asyncHandler) {
        final DeactivateEventSourceRequest finalRequest = (DeactivateEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeactivateEventSourceResult>(){

            @Override
            public DeactivateEventSourceResult call() throws Exception {
                DeactivateEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDeactivateEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteArchiveResult> deleteArchiveAsync(DeleteArchiveRequest request) {
        return this.deleteArchiveAsync(request, null);
    }

    @Override
    public Future<DeleteArchiveResult> deleteArchiveAsync(DeleteArchiveRequest request, final AsyncHandler<DeleteArchiveRequest, DeleteArchiveResult> asyncHandler) {
        final DeleteArchiveRequest finalRequest = (DeleteArchiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteArchiveResult>(){

            @Override
            public DeleteArchiveResult call() throws Exception {
                DeleteArchiveResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDeleteArchive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEventBusResult> deleteEventBusAsync(DeleteEventBusRequest request) {
        return this.deleteEventBusAsync(request, null);
    }

    @Override
    public Future<DeleteEventBusResult> deleteEventBusAsync(DeleteEventBusRequest request, final AsyncHandler<DeleteEventBusRequest, DeleteEventBusResult> asyncHandler) {
        final DeleteEventBusRequest finalRequest = (DeleteEventBusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEventBusResult>(){

            @Override
            public DeleteEventBusResult call() throws Exception {
                DeleteEventBusResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDeleteEventBus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePartnerEventSourceResult> deletePartnerEventSourceAsync(DeletePartnerEventSourceRequest request) {
        return this.deletePartnerEventSourceAsync(request, null);
    }

    @Override
    public Future<DeletePartnerEventSourceResult> deletePartnerEventSourceAsync(DeletePartnerEventSourceRequest request, final AsyncHandler<DeletePartnerEventSourceRequest, DeletePartnerEventSourceResult> asyncHandler) {
        final DeletePartnerEventSourceRequest finalRequest = (DeletePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePartnerEventSourceResult>(){

            @Override
            public DeletePartnerEventSourceResult call() throws Exception {
                DeletePartnerEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDeletePartnerEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {
        final DeleteRuleRequest finalRequest = (DeleteRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRuleResult>(){

            @Override
            public DeleteRuleResult call() throws Exception {
                DeleteRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDeleteRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeArchiveResult> describeArchiveAsync(DescribeArchiveRequest request) {
        return this.describeArchiveAsync(request, null);
    }

    @Override
    public Future<DescribeArchiveResult> describeArchiveAsync(DescribeArchiveRequest request, final AsyncHandler<DescribeArchiveRequest, DescribeArchiveResult> asyncHandler) {
        final DescribeArchiveRequest finalRequest = (DescribeArchiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeArchiveResult>(){

            @Override
            public DescribeArchiveResult call() throws Exception {
                DescribeArchiveResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribeArchive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventBusResult> describeEventBusAsync(DescribeEventBusRequest request) {
        return this.describeEventBusAsync(request, null);
    }

    @Override
    public Future<DescribeEventBusResult> describeEventBusAsync(DescribeEventBusRequest request, final AsyncHandler<DescribeEventBusRequest, DescribeEventBusResult> asyncHandler) {
        final DescribeEventBusRequest finalRequest = (DescribeEventBusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventBusResult>(){

            @Override
            public DescribeEventBusResult call() throws Exception {
                DescribeEventBusResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribeEventBus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventSourceResult> describeEventSourceAsync(DescribeEventSourceRequest request) {
        return this.describeEventSourceAsync(request, null);
    }

    @Override
    public Future<DescribeEventSourceResult> describeEventSourceAsync(DescribeEventSourceRequest request, final AsyncHandler<DescribeEventSourceRequest, DescribeEventSourceResult> asyncHandler) {
        final DescribeEventSourceRequest finalRequest = (DescribeEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventSourceResult>(){

            @Override
            public DescribeEventSourceResult call() throws Exception {
                DescribeEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribeEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePartnerEventSourceResult> describePartnerEventSourceAsync(DescribePartnerEventSourceRequest request) {
        return this.describePartnerEventSourceAsync(request, null);
    }

    @Override
    public Future<DescribePartnerEventSourceResult> describePartnerEventSourceAsync(DescribePartnerEventSourceRequest request, final AsyncHandler<DescribePartnerEventSourceRequest, DescribePartnerEventSourceResult> asyncHandler) {
        final DescribePartnerEventSourceRequest finalRequest = (DescribePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePartnerEventSourceResult>(){

            @Override
            public DescribePartnerEventSourceResult call() throws Exception {
                DescribePartnerEventSourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribePartnerEventSource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplayResult> describeReplayAsync(DescribeReplayRequest request) {
        return this.describeReplayAsync(request, null);
    }

    @Override
    public Future<DescribeReplayResult> describeReplayAsync(DescribeReplayRequest request, final AsyncHandler<DescribeReplayRequest, DescribeReplayResult> asyncHandler) {
        final DescribeReplayRequest finalRequest = (DescribeReplayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReplayResult>(){

            @Override
            public DescribeReplayResult call() throws Exception {
                DescribeReplayResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribeReplay(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(DescribeRuleRequest request) {
        return this.describeRuleAsync(request, null);
    }

    @Override
    public Future<DescribeRuleResult> describeRuleAsync(DescribeRuleRequest request, final AsyncHandler<DescribeRuleRequest, DescribeRuleResult> asyncHandler) {
        final DescribeRuleRequest finalRequest = (DescribeRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRuleResult>(){

            @Override
            public DescribeRuleResult call() throws Exception {
                DescribeRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDescribeRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableRuleResult> disableRuleAsync(DisableRuleRequest request) {
        return this.disableRuleAsync(request, null);
    }

    @Override
    public Future<DisableRuleResult> disableRuleAsync(DisableRuleRequest request, final AsyncHandler<DisableRuleRequest, DisableRuleResult> asyncHandler) {
        final DisableRuleRequest finalRequest = (DisableRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableRuleResult>(){

            @Override
            public DisableRuleResult call() throws Exception {
                DisableRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeDisableRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableRuleResult> enableRuleAsync(EnableRuleRequest request) {
        return this.enableRuleAsync(request, null);
    }

    @Override
    public Future<EnableRuleResult> enableRuleAsync(EnableRuleRequest request, final AsyncHandler<EnableRuleRequest, EnableRuleResult> asyncHandler) {
        final EnableRuleRequest finalRequest = (EnableRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableRuleResult>(){

            @Override
            public EnableRuleResult call() throws Exception {
                EnableRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeEnableRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListArchivesResult> listArchivesAsync(ListArchivesRequest request) {
        return this.listArchivesAsync(request, null);
    }

    @Override
    public Future<ListArchivesResult> listArchivesAsync(ListArchivesRequest request, final AsyncHandler<ListArchivesRequest, ListArchivesResult> asyncHandler) {
        final ListArchivesRequest finalRequest = (ListArchivesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListArchivesResult>(){

            @Override
            public ListArchivesResult call() throws Exception {
                ListArchivesResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListArchives(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventBusesResult> listEventBusesAsync(ListEventBusesRequest request) {
        return this.listEventBusesAsync(request, null);
    }

    @Override
    public Future<ListEventBusesResult> listEventBusesAsync(ListEventBusesRequest request, final AsyncHandler<ListEventBusesRequest, ListEventBusesResult> asyncHandler) {
        final ListEventBusesRequest finalRequest = (ListEventBusesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventBusesResult>(){

            @Override
            public ListEventBusesResult call() throws Exception {
                ListEventBusesResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListEventBuses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEventSourcesResult> listEventSourcesAsync(ListEventSourcesRequest request) {
        return this.listEventSourcesAsync(request, null);
    }

    @Override
    public Future<ListEventSourcesResult> listEventSourcesAsync(ListEventSourcesRequest request, final AsyncHandler<ListEventSourcesRequest, ListEventSourcesResult> asyncHandler) {
        final ListEventSourcesRequest finalRequest = (ListEventSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEventSourcesResult>(){

            @Override
            public ListEventSourcesResult call() throws Exception {
                ListEventSourcesResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListEventSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPartnerEventSourceAccountsResult> listPartnerEventSourceAccountsAsync(ListPartnerEventSourceAccountsRequest request) {
        return this.listPartnerEventSourceAccountsAsync(request, null);
    }

    @Override
    public Future<ListPartnerEventSourceAccountsResult> listPartnerEventSourceAccountsAsync(ListPartnerEventSourceAccountsRequest request, final AsyncHandler<ListPartnerEventSourceAccountsRequest, ListPartnerEventSourceAccountsResult> asyncHandler) {
        final ListPartnerEventSourceAccountsRequest finalRequest = (ListPartnerEventSourceAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPartnerEventSourceAccountsResult>(){

            @Override
            public ListPartnerEventSourceAccountsResult call() throws Exception {
                ListPartnerEventSourceAccountsResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListPartnerEventSourceAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPartnerEventSourcesResult> listPartnerEventSourcesAsync(ListPartnerEventSourcesRequest request) {
        return this.listPartnerEventSourcesAsync(request, null);
    }

    @Override
    public Future<ListPartnerEventSourcesResult> listPartnerEventSourcesAsync(ListPartnerEventSourcesRequest request, final AsyncHandler<ListPartnerEventSourcesRequest, ListPartnerEventSourcesResult> asyncHandler) {
        final ListPartnerEventSourcesRequest finalRequest = (ListPartnerEventSourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPartnerEventSourcesResult>(){

            @Override
            public ListPartnerEventSourcesResult call() throws Exception {
                ListPartnerEventSourcesResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListPartnerEventSources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReplaysResult> listReplaysAsync(ListReplaysRequest request) {
        return this.listReplaysAsync(request, null);
    }

    @Override
    public Future<ListReplaysResult> listReplaysAsync(ListReplaysRequest request, final AsyncHandler<ListReplaysRequest, ListReplaysResult> asyncHandler) {
        final ListReplaysRequest finalRequest = (ListReplaysRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReplaysResult>(){

            @Override
            public ListReplaysResult call() throws Exception {
                ListReplaysResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListReplays(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(ListRuleNamesByTargetRequest request) {
        return this.listRuleNamesByTargetAsync(request, null);
    }

    @Override
    public Future<ListRuleNamesByTargetResult> listRuleNamesByTargetAsync(ListRuleNamesByTargetRequest request, final AsyncHandler<ListRuleNamesByTargetRequest, ListRuleNamesByTargetResult> asyncHandler) {
        final ListRuleNamesByTargetRequest finalRequest = (ListRuleNamesByTargetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRuleNamesByTargetResult>(){

            @Override
            public ListRuleNamesByTargetResult call() throws Exception {
                ListRuleNamesByTargetResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListRuleNamesByTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {
        return this.listRulesAsync(request, null);
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request, final AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {
        final ListRulesRequest finalRequest = (ListRulesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRulesResult>(){

            @Override
            public ListRulesResult call() throws Exception {
                ListRulesResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListRules(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(ListTargetsByRuleRequest request) {
        return this.listTargetsByRuleAsync(request, null);
    }

    @Override
    public Future<ListTargetsByRuleResult> listTargetsByRuleAsync(ListTargetsByRuleRequest request, final AsyncHandler<ListTargetsByRuleRequest, ListTargetsByRuleResult> asyncHandler) {
        final ListTargetsByRuleRequest finalRequest = (ListTargetsByRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetsByRuleResult>(){

            @Override
            public ListTargetsByRuleResult call() throws Exception {
                ListTargetsByRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeListTargetsByRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request) {
        return this.putEventsAsync(request, null);
    }

    @Override
    public Future<PutEventsResult> putEventsAsync(PutEventsRequest request, final AsyncHandler<PutEventsRequest, PutEventsResult> asyncHandler) {
        final PutEventsRequest finalRequest = (PutEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutEventsResult>(){

            @Override
            public PutEventsResult call() throws Exception {
                PutEventsResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executePutEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPartnerEventsResult> putPartnerEventsAsync(PutPartnerEventsRequest request) {
        return this.putPartnerEventsAsync(request, null);
    }

    @Override
    public Future<PutPartnerEventsResult> putPartnerEventsAsync(PutPartnerEventsRequest request, final AsyncHandler<PutPartnerEventsRequest, PutPartnerEventsResult> asyncHandler) {
        final PutPartnerEventsRequest finalRequest = (PutPartnerEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPartnerEventsResult>(){

            @Override
            public PutPartnerEventsResult call() throws Exception {
                PutPartnerEventsResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executePutPartnerEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPermissionResult> putPermissionAsync(PutPermissionRequest request) {
        return this.putPermissionAsync(request, null);
    }

    @Override
    public Future<PutPermissionResult> putPermissionAsync(PutPermissionRequest request, final AsyncHandler<PutPermissionRequest, PutPermissionResult> asyncHandler) {
        final PutPermissionRequest finalRequest = (PutPermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPermissionResult>(){

            @Override
            public PutPermissionResult call() throws Exception {
                PutPermissionResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executePutPermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(PutRuleRequest request) {
        return this.putRuleAsync(request, null);
    }

    @Override
    public Future<PutRuleResult> putRuleAsync(PutRuleRequest request, final AsyncHandler<PutRuleRequest, PutRuleResult> asyncHandler) {
        final PutRuleRequest finalRequest = (PutRuleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRuleResult>(){

            @Override
            public PutRuleResult call() throws Exception {
                PutRuleResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executePutRule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(PutTargetsRequest request) {
        return this.putTargetsAsync(request, null);
    }

    @Override
    public Future<PutTargetsResult> putTargetsAsync(PutTargetsRequest request, final AsyncHandler<PutTargetsRequest, PutTargetsResult> asyncHandler) {
        final PutTargetsRequest finalRequest = (PutTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutTargetsResult>(){

            @Override
            public PutTargetsResult call() throws Exception {
                PutTargetsResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executePutTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        final RemovePermissionRequest finalRequest = (RemovePermissionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeRemovePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(RemoveTargetsRequest request) {
        return this.removeTargetsAsync(request, null);
    }

    @Override
    public Future<RemoveTargetsResult> removeTargetsAsync(RemoveTargetsRequest request, final AsyncHandler<RemoveTargetsRequest, RemoveTargetsResult> asyncHandler) {
        final RemoveTargetsRequest finalRequest = (RemoveTargetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTargetsResult>(){

            @Override
            public RemoveTargetsResult call() throws Exception {
                RemoveTargetsResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeRemoveTargets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartReplayResult> startReplayAsync(StartReplayRequest request) {
        return this.startReplayAsync(request, null);
    }

    @Override
    public Future<StartReplayResult> startReplayAsync(StartReplayRequest request, final AsyncHandler<StartReplayRequest, StartReplayResult> asyncHandler) {
        final StartReplayRequest finalRequest = (StartReplayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartReplayResult>(){

            @Override
            public StartReplayResult call() throws Exception {
                StartReplayResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeStartReplay(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(TestEventPatternRequest request) {
        return this.testEventPatternAsync(request, null);
    }

    @Override
    public Future<TestEventPatternResult> testEventPatternAsync(TestEventPatternRequest request, final AsyncHandler<TestEventPatternRequest, TestEventPatternResult> asyncHandler) {
        final TestEventPatternRequest finalRequest = (TestEventPatternRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestEventPatternResult>(){

            @Override
            public TestEventPatternResult call() throws Exception {
                TestEventPatternResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeTestEventPattern(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateArchiveResult> updateArchiveAsync(UpdateArchiveRequest request) {
        return this.updateArchiveAsync(request, null);
    }

    @Override
    public Future<UpdateArchiveResult> updateArchiveAsync(UpdateArchiveRequest request, final AsyncHandler<UpdateArchiveRequest, UpdateArchiveResult> asyncHandler) {
        final UpdateArchiveRequest finalRequest = (UpdateArchiveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateArchiveResult>(){

            @Override
            public UpdateArchiveResult call() throws Exception {
                UpdateArchiveResult result = null;
                try {
                    result = AmazonEventBridgeAsyncClient.this.executeUpdateArchive(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

